% Table for MC results

clear all;
small = 1.0e-10;
big = 1.0e+8;

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
datdir = '../mc_files/';
addpath('../matlab_functions');

% List Designs
Design_lst = {'Levy';'I1001';'I1003';'I1mat';'LTU003';'LTU500';'Bsheet';'SAR099';'SAR999'};
n_design = length(Design_lst);
ols_cscpc = NaN(2,n_design);
ols_cluster_state = NaN(2,n_design);
cfe_cluster_state = NaN(2,n_design);
cfe_cscpc_state = NaN(2,n_design);
n_m = 5;
cfe_cscpc_m = NaN(2,n_m,n_design);
cfe_cluster_m = NaN(2,n_m,n_design);
lbmgls_hr = NaN(2,n_design);
lbmgls_cscpc = NaN(2,n_design);
n_b = 5;
iso_cscpc_b = NaN(2,n_b,n_design);
n_k = 5;
iso_cscpc_k = NaN(2,n_b,n_design);
r2 = NaN(1,n_design);
i1_i0_tst = NaN(2,n_design);

% Documentation for file structure
%{
This documents the rows and cols for each method
The rows come in pairs, first entry is size, second entry is lenght of CI
The columns denote the various (m,b,q) parameters used ...

Levels:  This is OLS estimate .. 
	The rows (in pairs) are (1) SCPC, (2) C-SCPC, (3) Clustered (by state) SEs
	The columns index cluster size (m=30, 60, 120, 240)
	Note the column entries for the first 2 sets of rows are identical (no clusters).
	
ClustFE:  This is cluster fixed effect estimator 
	The rows (in pairs) are (1) Clustered SEs (2) SCPC, (3) C-SCPC
	The 6 columns index cluster size (States, then m = 30, 60, 120, 240, 360)

FGLS: This is the LMB-GLS estimator
	The rows (in pairs) are (1) HR (2) SCPC, (3) C-SCPC
	Their is a single column

isodiff: This is the isotropic difference estimator
	The rows (in pairs) index (1) SCPC and (2) C-SCPC)
  The 10 columns are: 
	[0.03,0.04,0.05,0.08,0.1,    1.0,2.0,4.0,10.0,20.0]
  where values below 1 are interpreted as the radius of the circle in percent of
  max distance in sample. For the first three radii, we drop 3.3%, 1.1%
  and 0.28% of obs due to lack of neighbors.
  Values 1 and above are interpreted as the (fixed across obs) number of
  nearest neighbors that we average before computing the difference.

R2: This is the R2 in the levels regression
	There is a single row
	
%}


kstr = 'k1';

 % Read in Results
 for id = 1:n_design
   dstr = char(Design_lst(id));

  % I(1) and I(0) test p-values
  fname = [datdir dstr '_' kstr '_tests'];
  tmp = readmatrix(fname);
  ii = isnan(tmp);
  i1_i0_tst(:,id)=tmp(ii==0);

   % R2  
   % Read R2 from CSV file 
   fname = [datdir dstr '_' kstr '_R2'];
   tmp = readmatrix(fname);
   ii = isnan(tmp);
   r2(:,id)=tmp(ii==0);

   % OLS CSCPC
   fname = [datdir dstr '_' kstr '_levels'];
   tmp = readmatrix(fname,'Range','A3:A4');
   ols_cscpc(:,id)=tmp;

   % OLS Cluster_State
   fname = [datdir dstr '_' kstr '_levels'];
   tmp = readmatrix(fname,'Range','A5:A6');
   ols_cluster_state(:,id)=tmp;

   % CFE Cluster_state
   fname = [datdir dstr '_' kstr '_clustFE'];  
   tmp = readmatrix(fname,'Range','A1:A2');
   cfe_cluster_state(:,id)=tmp;

   % CFE CSPC_state
   fname = [datdir dstr '_' kstr '_clustFE'];  
   tmp = readmatrix(fname,'Range','A5:A6');
   cfe_cscpc_state(:,id)=tmp;

   % CFE CSCPC_m
   fname = [datdir dstr '_' kstr '_clustFE'];  
   tmp = readmatrix(fname,'Range','B5:F6');  % CSCPC for various m
   cfe_cscpc_m(:,:,id)=tmp;

   % CFE cluster_m
   fname = [datdir dstr '_' kstr '_clustFE'];  
   tmp = readmatrix(fname,'Range','B1:F2');  % Cluster for various m
   cfe_cluster_m(:,:,id)=tmp;

  % LBMGLS HR
  fname = [datdir dstr '_' kstr '_FGLS'];
  tmp = readmatrix(fname,'Range','A1:A2');
  lbmgls_hr(:,id)=tmp;

  % LBMGLS CSCPC
  fname = [datdir dstr '_' kstr '_FGLS'];
  tmp = readmatrix(fname,'Range','A5:A6');
  lbmgls_cscpc(:,id)=tmp;

  % ISO_b CSCPC
  fname = [datdir dstr '_' kstr '_isodiff'];
  tmp = readmatrix(fname,'Range','A3:E4');  % Iso for various b
  iso_cscpc_b(:,:,id)=tmp;

  % ISO_b CSCPC
  fname = [datdir dstr '_' kstr '_isodiff'];
  tmp = readmatrix(fname,'Range','F3:J4');  % Iso for various b
  iso_cscpc_k(:,:,id)=tmp;

 end

  % Print out results
  outfile_name = [outdir 'mc_table_' kstr '.csv'];
  fileID = fopen(outfile_name,'w');
  fprintf(fileID,'Method, ');
  for id = 1:n_design
        dstr = char(Design_lst(id));
        fprintf(fileID,dstr);
        fprintf(fileID,' ,');
  end
  fprintf(fileID,',Avg \n');

  fprintf(fileID,'LFUR p-value,');
  tmp = i1_i0_tst;
  prt_tmp(tmp(1,:),fileID);
  fprintf(fileID,'LFST p-value,');
  prt_tmp(tmp(2,:)',fileID);

  fprintf(fileID,'\n\n');
  
  fprintf(fileID,'OLS (CSCPC),');
  tmp = ols_cscpc;
  prt_tmp(tmp(1,:),fileID);
  fprintf(fileID,' ,');
  prt_tmp(tmp(2,:)',fileID);

  fprintf(fileID,'NN-Difference (cscpc),',i);
    tmp = squeeze(iso_cscpc_k(:,1,:));
    prt_tmp(tmp(1,:),fileID);
    fprintf(fileID,' ,');
    prt_tmp(tmp(2,:)',fileID);
  
  fprintf(fileID,'iso b = 0.04 (cscpc),',i);
    tmp = squeeze(iso_cscpc_b(:,2,:));
    prt_tmp(tmp(1,:),fileID);
    fprintf(fileID,' ,');
    prt_tmp(tmp(2,:)',fileID);

  fprintf(fileID,'iso b = 0.08 (cscpc),',i);
    tmp = squeeze(iso_cscpc_b(:,4,:));
    prt_tmp(tmp(1,:),fileID);
    fprintf(fileID,' ,');
    prt_tmp(tmp(2,:)',fileID);

  fprintf(fileID,'FE-State (cscpc),',i);
    tmp = cfe_cscpc_state(:,:);
    prt_tmp(tmp(1,:),fileID);
    fprintf(fileID,' ,');
    prt_tmp(tmp(2,:)',fileID);  
  
  fprintf(fileID,'FE-60 (cscpc),',i);
    tmp = squeeze(cfe_cscpc_m(:,2,:));  % m = 60
    prt_tmp(tmp(1,:),fileID);
    fprintf(fileID,' ,');
    prt_tmp(tmp(2,:)',fileID); 

  fprintf(fileID,'FE-240 (cscpc),',i);
    tmp = squeeze(cfe_cscpc_m(:,4,:));  % m = 240
    prt_tmp(tmp(1,:),fileID);
    fprintf(fileID,' ,');
    prt_tmp(tmp(2,:)',fileID); 

  fprintf(fileID,'LBMGLS (CSCPC),');
    tmp = lbmgls_cscpc;
    prt_tmp(tmp(1,:),fileID);
    fprintf(fileID,' ,');
    prt_tmp(tmp(2,:)',fileID);

  % Additional Results
  fprintf(fileID,'\n\n');
  fprintf(fileID,'OLS (Cluster by State),');
  tmp = ols_cluster_state;
  prt_tmp(tmp(1,:),fileID);
%   fprintf(fileID,' ,');
%   prt_tmp(tmp(2,:)',fileID);

  fprintf(fileID,'FE-State (Cluster),',i);
    tmp = cfe_cluster_state(:,:);
    prt_tmp(tmp(1,:),fileID);
    % fprintf(fileID,' ,');
    % prt_tmp(tmp(2,:)',fileID); 
  
  fprintf(fileID,'FE-60 (Cluster),',i);
    tmp = squeeze(cfe_cluster_m(:,2,:));  % m = 60
    prt_tmp(tmp(1,:),fileID);
    % fprintf(fileID,' ,');
    % prt_tmp(tmp(2,:)',fileID); 

  fprintf(fileID,'FE-240 (Cluster),',i);
    tmp = squeeze(cfe_cluster_m(:,4,:));  % m = 240
    prt_tmp(tmp(1,:),fileID);
    % fprintf(fileID,' ,');
    % prt_tmp(tmp(2,:)',fileID);  


function prt_tmp(tmp,fileID)
n_design = length(tmp);
for id = 1:n_design
        fprintf(fileID,'%5.2f',tmp(id));
        % if id == n_design
        %     fprintf(fileID,' \n');
        % else
        %     fprintf(fileID,' ,');
        % end
        fprintf(fileID,' ,');
end
x = mean(tmp);
fprintf(fileID,' , %5.2f \n',x);

end
