clear

*************************************************************
import excel "Chetty_Example.xlsx", sheet("Sheet1") firstrow
log using Chetty_Example_Figure_1_4.log, replace
***********************************
desc

gen cz1990 = CZ
gen cz = CZ
global out "cz1990"

egen x = std(AM)
egen y = std(AM_d)
maptile x, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Chetty_AM_Figure_1.png, replace
maptile y, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Chetty_d_AM_Figure_4.png, replace
drop x
drop y


egen x = std(TLFPR)
egen y = std(TLFPR_d)
maptile x, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Chetty_TLFPR_Figure_1.png, replace
maptile y, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Chetty_d_TLFPR_Figure_4.png, replace
drop x
drop y

egen am_level = std(AM)
egen tlfpr_level = std(TLFPR)

regress am_level tlfpr_level
regress am_level tlfpr_level,r
regress am_level tlfpr_level, cluster(state_id)

regress AM_d TLFPR_d, cluster(state_id)

log close