set more off
set linesize 240
clear all
*************************************************************
* CS Levy Brownian Motion Example
*************************************************************
import excel "Levy_CZ.xlsx", sheet("Sheet1") firstrow
log using Levy_Figure_1_b.log, replace
***********************************
desc
gen cz = CZ
global out "cz1990"

egen xe = std(x)
egen ye = std(y)
maptile xe, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Figure_1_b_right.png, replace

maptile ye, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Figure_1_b_left.png, replace
 
reg y x
reg y x,r
reg y x, cluster(state_id)

*scatter x y, || lfit x y, saving(conus_lbm_x_y_scatter,replace) 
*graph export conus_lbm_x_y_scatter.png, replace

log close

clear all

*************************************************************
import excel "Chetty_Example.xlsx", sheet("Sheet1") firstrow
log using Chetty_Example_Figure_1c_4.log, replace
***********************************
desc

gen cz1990 = CZ
gen cz = CZ
global out "cz1990"

egen x = std(AM)
egen y = std(AM_d)
maptile x, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Figure_1_c_left.png, replace
maptile y, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Figure_4_left.png, replace
drop x
drop y


egen x = std(TLFPR)
egen y = std(TLFPR_d)
maptile x, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Figure_1_c_right.png, replace
maptile y, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Figure_4_right.png, replace
drop x
drop y

egen am_level = std(AM)
egen tlfpr_level = std(TLFPR)

regress am_level tlfpr_level
regress am_level tlfpr_level,r
regress am_level tlfpr_level, cluster(state_id)

regress AM_d TLFPR_d, cluster(state_id)

log close