% Chetty Data and I(1), I(0), etc. tests


rng(54321);
figdir = "";
% Read Data
dataxls = '../Data/Chetty_Mobility/Chetty_Data_Labels.xlsx';
[~,tmp] = xlsread(dataxls,'A2:AT2');
VariableDesc = tmp';
dataxls = '../Data/Chetty_Mobility/Chetty_Data_1.xlsx';
T = readtable(dataxls);
CZ = T{:,'CZ'};
LatLon = [T{:,'Lat'} T{:,'Lon'}];
VariableNames=T.Properties.VariableNames;
State = T{:,'State'};
[Su,ia,state_id]=unique(State);
% Find Continental US .. delete HI and AK
ii_hi = ismember(State,'HI');
ii_ak = ismember(State,'AK');
ii_48 = ones(size(State,1),1)-ii_hi-ii_ak;
LatLon = LatLon(ii_48==1,:);
state_id = state_id(ii_48==1);
CZ = CZ(ii_48==1);
Lat = LatLon(:,1);
Lon = LatLon(:,2);
n = size(Lat,1);

% Get LBM-GLS Matrix
s = LatLon;
latlongflag = 1;
H = lbm_gls_matrix(s,latlongflag);

% Get LBM Covariance Matrix
distmat = getdistmat_normalized(s,latlongflag);
sigma_lbm_dm = get_sigma_lbm_dm(distmat);
sigma_lbm_dm_sqrt = sqrt_psd(sigma_lbm_dm);

% Data
S = sigma_lbm_dm_sqrt*randn(n,2);
% Standardize 
S = (S-mean(S))./std(S);
% Form 'Differences'
dS = H*S;

x = S(:,1);
y = S(:,2);
d_x = dS(:,1);
d_y = dS(:,2);
[betahat_xy,~,se_beta_xy,~,rbarsq_xy] = hac_ols(y,x,0,1);
[betahat_dxdy,~,se_beta_dxdy,~,rbarsq_dxdy] = hac_ols(d_y,d_x,0,1);
fprintf('%5.3f (%5.3f) %5.2f \n',[betahat_xy se_beta_xy rbarsq_xy]);
fprintf('%5.3f (%5.3f) %5.2f \n \n',[betahat_dxdy se_beta_dxdy rbarsq_dxdy]);

Ts = table(CZ,state_id,Lat,Lon,x,y);
writetable(Ts,'Levy_CZ.xlsx');

Tds = table(CZ,state_id,Lat,Lon,d_x,d_y);
writetable(Tds,'d_Levy_CZ.xlsx');

% % Scatter plot of x and y
% fig = figure;
% scatter(x,y,40,"blue","filled");
% h = lsline;
% h.Color = 'k';
% h.LineWidth = 2;
% xlabel('X_l');
% ylabel('Y_l');
% ax = gca;
% ax.FontSize = 15;
% saveas(gcf,['Levy_CZ_Scatter.png']);
% close(gcf);

% % Scatter plot of x and y
% fig = figure;
% scatter(d_x,d_y,40,"blue","filled");
% h = lsline;
% h.Color = 'k';
% h.LineWidth = 2;
% xlabel('X (LBM-GLS Transformed)');
% ylabel('Y (LMB-GLS Transformed)');
% ax = gca;
% ax.FontSize = 15;
% saveas(gcf,['d_Levy_CZ_Scatter.png']);
% close(gcf);
