set more off
set linesize 240
clear all
*************************************************************
* CS Levy Brownian Motion Example
*************************************************************
import excel "Levy_CZ.xlsx", sheet("Sheet1") firstrow
log using Levy_Figure_1.log, replace
***********************************
desc
gen cz = CZ
global out "cz1990"

egen xe = std(x)
egen ye = std(y)
maptile xe, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Levy_x_Figure_1.png, replace

maptile ye, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Levy_y_Figure_1.png, replace
 
reg y x
reg y x,r
reg y x, cluster(state_id)

*scatter x y, || lfit x y, saving(conus_lbm_x_y_scatter,replace) 
*graph export conus_lbm_x_y_scatter.png, replace

log close
