% Time Series Plotted in panel (a) of Figures 1

rng(987654);

n = 250;
e = randn(n+50,2);
X = cumsum(e);
X = X(end-n+1:end,:);
t = (1:1:n)';
x = X(:,1);
y = X(:,2);

% Save as Series to be read into STATA
tt=table(t,x,y);
writetable(tt,'Time_Series_RW.xlsx');

% Plots for Figure 1
x = x-x(1);
y = y-y(1);
fig=figure('Units', 'normalized', 'Position', [0 0 0.3 0.5]); % For Dell Wide Monitor
plot(t,x,'-b','LineWidth',2.0);
hold on;
z = zeros(n,1);
plot(t,z,'-k','LineWidth',1.0);
hold off;
% Eliminate axes numbers
set(gca,'XTickLabel',[],'YTickLabel',[]);
% Eliminate y-axis axes ticks
set(gca,'Ytick',[]);
% Eliminate x-axis axes lines
set(gca,'XColor','none');
% Save as png file
print(fig,'-dpng','-r600','Figure_1_a_right.png');
% Close graph
close(fig);

fig=figure('Units', 'normalized', 'Position', [0 0 0.3 0.5]); % For Dell Wide Monitor
plot(t,y,'-b','LineWidth',2.0);
hold on;
z = zeros(n,1);
plot(t,z,'-k','LineWidth',1.0);
hold off;
% Eliminate axes numbers
set(gca,'XTickLabel',[],'YTickLabel',[]);
% Eliminate y-axis axes ticks
set(gca,'Ytick',[]);
% Eliminate x-axis axes lines
set(gca,'XColor','none');
% Save as png file
print(fig,'-dpng','-r600','Figure_1_a_left.png');
% Close graph
close(fig);

% Regression of y on x
x = [x ones(n,1)];
ima = ceil(0.75*(n^0.333));
[betahat,vbeta,se_beta,ser,rbarsq] = hac_ols(y,x,ima,1);
tstat = betahat(1)/se_beta(1);
fprintf('t-statistic = %f\n',tstat);
fprintf('R^2 = %f\n',rbarsq);

% Carry out MC to find prob(|t-hac| > 1.96)
nmc = 10000;
t_hac = zeros(nmc,1);   

for i=1:nmc
    e = randn(n+50,2);
    X = cumsum(e);
    X = X(end-n+1:end,:);
    x = X(:,1);
    y = X(:,2);
    x = [x ones(n,1)];
    [betahat,vbeta,se_beta,ser,rbarsq] = hac_ols(y,x,ima,1);
    t_hac(i) = betahat(1)/se_beta(1);
end
tmp=mean(abs(t_hac) > 1.96);
fprintf('Prob(|t-hac| > 1.96) = %f\n',tmp);
