% List of Countries with Sample Periods, etc.
clear all;
small = 1.0e-10;

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
matdir = 'mat/';

% Load matlab files with data
fstr = [matdir 'calvec']; load(fstr);
fstr = [matdir 'country']; load(fstr);
fstr = [matdir 'country_code']; load(fstr);
fstr = [matdir 'yp']; load(fstr);
fstr = [matdir 'pop']; load(fstr);
calvec = (1900:2017)';

% Update data to eliminate singletons (single value surrounded by missing
% values
yp = delete_singleton(yp);
n_t = size(calvec,1);
n_c = size(yp,2);

% List countries that are excluded
outfile_name = [outdir 'TableA1_List_of_countries.csv'];
fileID = fopen(outfile_name,'w');
fprintf(fileID,'Country,Country,GDP(2017),Pop(2017),nyears,start, end \n');

for i = 1:n_c;
        str1 = char(country_code(i));
        str2 = char(country(i));
        fprintf(fileID,[str1 ',' str2 ',']);
        fprintf(fileID,'%8.1f ,',yp(end,i));
        fprintf(fileID,'%8.1f ,',pop(end,i));
        jj = isnan(yp(:,i));
        nnn = sum(jj==0);
        fprintf(fileID,'%3i ,',nnn);
        ifirst = 0;
        for t = 1:n_t;
            if ifirst == 0;
                if isnan(yp(t,i)) == 0;
                  fprintf(fileID,'%4i ,',calvec(t));
                  ifirst = 1;
                end;
            end;
            if ifirst == 1;
                if isnan(yp(t,i)) == 1;
                    fprintf(fileID,'%4i ,',calvec(t-1));
                  ifirst = 0;
                end;
            end;
        end;
        if ifirst == 1;
            fprintf(fileID,'%4i, \n',calvec(end));
        else;
            fprintf(fileID,'\n');
        end;  
end;

% List countries that are excluded
outfile_name = [outdir 'TableA3_NumberofCountries_by_Year.csv'];
fileID = fopen(outfile_name,'w');
fprintf(fileID,'Year, Number \n');
for t = 1:n_t;
    tmp = yp(t,:)';
    n = sum(isnan(tmp) == 0);
    fprintf(fileID,'%4i, %3i \n',[calvec(t) n]);
end;

