% 

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
matdir = 'mat/';
mcmcdir = 'mcmc/';


% Model Name
mod_name = '_baseline';

% Load Individual Elements
fstr = [mcmcdir 'pwcorr_del50U_draws' mod_name];load(fstr);
fstr = [mcmcdir 'pwcorr_del50Y_draws' mod_name];load(fstr);
fstr = [mcmcdir 'pwcorr_U_draws' mod_name];load(fstr);
fstr = [matdir 'country_code']; load(fstr);
n_c = size(country_code,1);
n_rep = size(pwcorr_del50U_draws,2);

pct = [0.05 0.16 0.50 0.85 0.95]';
pwcorr_del50Y_summary = pw_corr_summary(pwcorr_del50Y_draws,pct,n_c,n_rep);
pwcorr_del50U_summary = pw_corr_summary(pwcorr_del50U_draws,pct,n_c,n_rep);
pwcorr_U_summary = pw_corr_summary(pwcorr_U_draws,pct,n_c,n_rep);

% Write Posterior Means To CSV Files
outfile_name = [outdir 'pwcorr_del50U_summary' mod_name '.csv'];
fileID = fopen(outfile_name,'w');
prt_p_summary(pwcorr_del50U_summary,country_code,fileID,pct);
 
outfile_name = [outdir 'pwcorr_U_summary' mod_name '.csv'];
fileID = fopen(outfile_name,'w');
prt_p_summary(pwcorr_U_summary,country_code,fileID,pct);
 
outfile_name = [outdir 'pwcorr_del50Y_summary' mod_name '.csv'];
fileID = fopen(outfile_name,'w');
prt_p_summary(pwcorr_del50Y_summary,country_code,fileID,pct);

% Posterior Mean
pm_del50U = squeeze(pwcorr_del50U_summary(:,:,1));
pm_del50Y = squeeze(pwcorr_del50Y_summary(:,:,1));
pm_U = squeeze(pwcorr_U_summary(:,:,1));
