
% Construct a Forecast Picture For each country
nT = 118
for ic = 1:n_c;
    yfcst_m = NaN(T+100,5);
    yfcst_m(T+1:T+100,:) = squeeze(yfcst_m_pct(T+1:T+100,ic,:));
    yfcst_u = NaN(T+100,5);
    yfcst_u(T+1:T+100,:) = squeeze(yfcst_u_pct(T+1:T+100,ic,:));
    
    fig = figure;
    plot(calvec_p,exp(yall),'LineWidth',1,'color',rgb('LightBlue'));
    hold on;
      plot(calvec_p,exp(yall(:,ic)),'- k','LineWidth',1);
      x = calvec_p(T+1:T+100);
      x2 = [x;flipud(x)];
      z = [exp(yfcst_m(T+1:T+100,4));flipud(exp(yfcst_m(T+1:T+100,5)))];
      fill(x2,z,rgb('LightSalmon'),'EdgeColor','none');
      z = [exp(yfcst_m(T+1:T+100,4));flipud(exp(yfcst_m(T+1:T+100,3)))];
      fill(x2,z,rgb('Salmon'),'EdgeColor','none');
      z = [exp(yfcst_m(T+1:T+100,3));flipud(exp(yfcst_m(T+1:T+100,2)))];
      fill(x2,z,rgb('Salmon'),'EdgeColor','none');
      z = [exp(yfcst_m(T+1:T+100,2));flipud(exp(yfcst_m(T+1:T+100,1)))];
      fill(x2,z,rgb('LightSalmon'),'EdgeColor','none');  
      plot(calvec_p,exp(yfcst_m(:,3)),'- r','LineWidth',3);
      
      plot(calvec_p,exp(yfcst_u(:,[1 5])),': b','LineWidth',1.5);
      plot(calvec_p,exp(yfcst_u(:,[2 4])),'-- b','LineWidth',1);
      plot(calvec_p,exp(yfcst_u(:,3)),'- b','LineWidth',1); 

   hold off;
   set(gca, 'YScale', 'log');
   ylabel('2011 USD');
   xlabel('Year');
   xlim([1900 2130]);
   str_tmp = char(country(ic));
   title(str_tmp);
   str_tmp = char(country_code(ic));
   figname = ['figure_14_individual_' str_tmp mod_name]; 
   orient landscape;
   print(fig, [figdir_fcst, figname], '-dpdf','-bestfit');
   close(gcf);
end;