% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
matdir = 'mat/';
mcmcdir = 'mcmc/';

% Model Name
mod_name = '_baseline';
% mod_name = '_fgamma05';
% mod_name = '_fgamma15';
% mod_name = '_q_8';
% mod_name = '_q_20';

% Save Individual Elements
fstr = [mcmcdir 'stddev_del50U_draws' mod_name];load(fstr);
fstr = [mcmcdir 'stddev_U_draws' mod_name];load(fstr);
fstr = [mcmcdir 'halflife_draws' mod_name];load(fstr);
fstr = [mcmcdir 'U0_draws' mod_name];load(fstr);
fstr = [mcmcdir 'paths_U_draws' mod_name];load(fstr);
fstr = [matdir 'country_code']; load(fstr);

n_c = size(halflife_draws,1);
n_rep = size(halflife_draws,2);

% Summary Results
pct = [0.05 1/6 0.5 5/6 0.95];
[halflife_pct,halflife_m_pct,halflife_dm_pct] = x_draws_pct_summary(halflife_draws,pct);
[stddev_U_pct,stddev_U_m_pct,stddev_U_dm_pct] = x_draws_pct_summary(stddev_U_draws,pct);
[stddev_del50U_pct,stddev_del50U_m_pct,stddev_del50U_dm_pct] = x_draws_pct_summary(stddev_del50U_draws,pct);

dU_2017_60 = squeeze(paths_U_draws(118,:,:)-paths_U_draws(61,:,:));
du_2017_60_m = mean(dU_2017_60,2);

% Print out some results
outfile_name = [outdir 'summarize_results_c_process_1_' mod_name '.csv'];
fileID = fopen(outfile_name,'w');
fprintf(fileID,'Summary of distributions for parameters of u process \n\n');
fprintf(fileID,'Percentile,');
prtmat_comma(pct,fileID,'%5.3f','\n');
fprintf(fileID,'Posteriors \n');
fprintf(fileID,'halflife: pooled,');
prtmat_comma(halflife_pct',fileID,'%5.3f','\n');

fprintf(fileID,'\n');
fprintf(fileID,'STD_U: pooled,');
prtmat_comma(stddev_U_pct',fileID,'%5.3f','\n');

fprintf(fileID,'\n');
fprintf(fileID,'STD_del50U: pooled,');
prtmat_comma(stddev_del50U_pct',fileID,'%5.3f','\n');

% Load Lists
load([matdir 'oecd_list']);

i_oecd = zeros(n_c,1);
nn = size(oecd_list,1);
for j = 1:nn;
    ss = char(oecd_list(j));
    jj = colnumber(ss,country_code);
    if jj > 0;
      i_oecd(jj) = 1;
    end;
end;

[halflife_pct,halflife_m_pct,halflife_dm_pct] = x_draws_pct_summary(halflife_draws(i_oecd==1,:),pct);
[stddev_U_pct,stddev_U_m_pct,stddev_U_dm_pct] = x_draws_pct_summary(stddev_U_draws(i_oecd==1,:),pct);
[stddev_del50U_pct,stddev_del50U_m_pct,stddev_del50U_dm_pct] = x_draws_pct_summary(stddev_del50U_draws(i_oecd==1,:),pct);

% Print out some results
fprintf(fileID,'\n\n OECD Countries \n\n');
fprintf(fileID,'Percentile,');
prtmat_comma(pct,fileID,'%5.3f','\n');
fprintf(fileID,'Posteriors \n');
fprintf(fileID,'halflife: pooled,');
prtmat_comma(halflife_pct',fileID,'%5.3f','\n');

fprintf(fileID,'\n');
fprintf(fileID,'STD_U: pooled,');
prtmat_comma(stddev_U_pct',fileID,'%5.3f','\n');

fprintf(fileID,'\n');
fprintf(fileID,'STD_del50U: pooled,');
prtmat_comma(stddev_del50U_pct',fileID,'%5.3f','\n');

[halflife_pct,halflife_m_pct,halflife_dm_pct] = x_draws_pct_summary(halflife_draws(i_oecd==0,:),pct);
[stddev_U_pct,stddev_U_m_pct,stddev_U_dm_pct] = x_draws_pct_summary(stddev_U_draws(i_oecd==0,:),pct);
[stddev_del50U_pct,stddev_del50U_m_pct,stddev_del50U_dm_pct] = x_draws_pct_summary(stddev_del50U_draws(i_oecd==0,:),pct);

% Print out some results
fprintf(fileID,'\n\n Non-OECD Countries \n\n');
fprintf(fileID,'Percentile,');
prtmat_comma(pct,fileID,'%5.3f','\n');
fprintf(fileID,'Posteriors \n');
fprintf(fileID,'halflife: pooled,');
prtmat_comma(halflife_pct',fileID,'%5.3f','\n');

fprintf(fileID,'\n');
fprintf(fileID,'STD_U: pooled,');
prtmat_comma(stddev_U_pct',fileID,'%5.3f','\n');

fprintf(fileID,'\n');
fprintf(fileID,'STD_del50U: pooled,');
prtmat_comma(stddev_del50U_pct',fileID,'%5.3f','\n');

% Sumamrize Results by Country
outfile_name = [outdir 'summarize_results_c_process_by_country_' mod_name '.csv'];
fileID2 = fopen(outfile_name,'w');
fprintf(fileID2,',,');
prtmat_comma(pct,fileID2,'%5.2f',',,');
prtmat_comma(pct,fileID2,'%5.2f',',,');
prtmat_comma(pct,fileID2,'%5.2f','\n');
fprintf(fileID2,'Country,,Halflife,,,,STD_c,,,,STD_Del50c,,, \n');


for ic = 1:n_c;
    fprintf(fileID2,[char(country_code(ic)) ',,']);
    tmp = pctile_mean(halflife_draws(ic,:)',pct)';
    prtmat_comma(tmp(2:end),fileID2,'%5.0f',',,');
   
    tmp = pctile_mean(stddev_U_draws(ic,:)',pct)';
    prtmat_comma(tmp(2:end),fileID2,'%5.2f',',,');
    
    tmp = pctile_mean(stddev_del50U_draws(ic,:)',pct)';
    prtmat_comma(tmp(2:end),fileID2,'%5.2f','\n');   
end;

% Figure 8  Posteriors of Sigma_c and Half-life for OECD and non-OECD
% countries

% panel (a)
x_draws_oecd = stddev_U_draws(i_oecd==1,:);
x_draws_nonoecd = stddev_U_draws(i_oecd==0,:);

% Vectorize draws
v_draws_oecd = reshape(x_draws_oecd,size(x_draws_oecd,1)*size(x_draws_oecd,2),1);
v_draws_nonoecd = reshape(x_draws_nonoecd,size(x_draws_nonoecd,1)*size(x_draws_nonoecd,2),1);

min(v_draws_oecd)
max(v_draws_oecd)
[f_oecd,xi_oecd] = ksdensity(v_draws_oecd,'Support',[0.5 1.8],'BoundaryCorrection','reflection');
[f_nonoecd,xi_nonoecd] = ksdensity(v_draws_nonoecd,'Support',[0.5 1.8],'BoundaryCorrection','reflection');

figure_8_a;


% panel (b)
x_draws_oecd = halflife_draws(i_oecd==1,:);
x_draws_nonoecd = halflife_draws(i_oecd==0,:);

% Vectorize draws
v_draws_oecd = reshape(x_draws_oecd,size(x_draws_oecd,1)*size(x_draws_oecd,2),1);
v_draws_nonoecd = reshape(x_draws_nonoecd,size(x_draws_nonoecd,1)*size(x_draws_nonoecd,2),1);

min(v_draws_oecd)
max(v_draws_oecd)
[f_oecd,xi_oecd] = ksdensity(v_draws_oecd,'Support',[24.99 800],'BoundaryCorrection','reflection');
[f_nonoecd,xi_nonoecd] = ksdensity(v_draws_nonoecd,'Support',[24.99 800],'BoundaryCorrection','reflection');

figure_8_b;

% Figure 9
U0_mean = mean(U0_draws')';
sdU_mean = mean(stddev_U_draws')';
sddelU_mean = mean(stddev_del50U_draws')';
hl_mean = mean(halflife_draws')'; 

figure_9;




    
