% Forecast Results

% Descriptive Statists
clear all;
small = 1.0e-10;
pct = [0.05 1/6 0.50 5/6 0.95]';

% Model Name
mod_name = '_baseline';

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
matdir = 'mat/';
mcmcdir = 'mcmc/';
figdir_fcst = 'fig_fcst/';

fstr = [matdir 'country_code']; load(fstr);
fstr = [matdir 'country']; load(fstr);
fstr = [matdir 'yp']; load(fstr);
fstr = [matdir 'pop']; load(fstr);
n_c = size(country_code,1);
fstr = [matdir 'yfit_mat'];load(fstr);  %Trends .. for plotting

% Load Lists
load([matdir 'oecd_list']);
i_oecd = zeros(n_c,1);
nn = size(oecd_list,1);
for j = 1:nn;
    ss = char(oecd_list(j));
    jj = colnumber(ss,country_code);
    if jj > 0;
      i_oecd(jj) = 1;
    end;
end;

% Read in a Forecast path
mod_name = '_poos98';
Tis = 98; % In-sample values
% load Paths
fstr = [mcmcdir 'f_draws_poos' mod_name];load(fstr);
fstr = [mcmcdir 'u_draws_poos' mod_name];load(fstr);

% Compute in-sample values
u_is_draws_poos = u_draws_poos(1:Tis,:,:);
f_is_draws_poos = f_draws_poos(1:Tis,:);

% Compute Out of sample values
Yos = 2017;
Tos = 1+Yos-1900;
nTos = Tos-Tis;

% Percentiles from POOS
f_gr_draws_poos = (f_draws_poos(Tos,:)-f_draws_poos(Tis,:))/nTos;
u_gr_draws_poos = (squeeze(u_draws_poos(Tos,:,:)-u_draws_poos(Tis,:,:)))/nTos;
u_gr_mean_draws_poos = mean(u_gr_draws_poos,1);
fu_gr_draws_poos = f_gr_draws_poos+u_gr_mean_draws_poos;
udm_gr_draws_poos = u_gr_draws_poos - repmat(u_gr_mean_draws_poos,n_c,1);

% Compute percentiles:
tmp = pctile_mean(f_gr_draws_poos',pct)';
f_gr_mean_poos = tmp(1);
f_gr_pct_poos = tmp(2:end);
u_gr_mean_poos = NaN(n_c,1);
u_gr_pct_poos = NaN(n_c,size(pct,1));
for i = 1:n_c;
   tmp = pctile_mean(u_gr_draws_poos(i,:)',pct)';
   u_gr_mean_poos(i) = tmp(1);
   u_gr_pct_poos(i,:) = tmp(2:end)';
end;

% Acutal Values

% load Paths
mod_name = '_baseline';
fstr = [mcmcdir 'path_F_draws' mod_name];load(fstr);
fstr = [mcmcdir 'paths_U_draws' mod_name];load(fstr);

% Rename;
u_draws = paths_U_draws;
f_draws = path_F_draws;
clear paths_U_draws;
clear path_F_draws;

% Construct percentiles for average growth rates T1 to end of Sample
f_gr_draws = (f_draws(Tos,:)-f_draws(Tis,:))/nTos;
u_gr_draws = (squeeze(u_draws(Tos,:,:)-u_draws(Tis,:,:)))/nTos;
u_gr_mean_draws = mean(u_gr_draws,1);
fu_gr_draws = f_gr_draws+u_gr_mean_draws;
udm_gr_draws = u_gr_draws - repmat(u_gr_mean_draws,n_c,1);

% Compute percentiles:
tmp = pctile_mean(f_gr_draws',pct)';
f_gr_mean = tmp(1);
f_gr_pct = tmp(2:end);

tmp = pctile_mean(u_gr_mean_draws',pct)';
u_gr_mean_mean = tmp(1);
u_gr_mean_pct = tmp(2:end);

tmp = pctile_mean(fu_gr_draws',pct)';
fu_gr_mean = tmp(1);
fu_gr_pct = tmp(2:end);

u_gr_mean = NaN(n_c,1);
u_gr_pct = NaN(n_c,size(pct,1));
for i = 1:n_c;
   tmp = pctile_mean(u_gr_draws(i,:)',pct)';
   u_gr_mean(i) = tmp(1);
   u_gr_pct(i,:) = tmp(2:end)';
end;

udm_gr_mean = NaN(n_c,1);
udm_gr_pct = NaN(n_c,size(pct,1));
for i = 1:n_c;
   tmp = pctile_mean(udm_gr_draws(i,:)',pct)';
   udm_gr_mean(i) = tmp(1);
   udm_gr_pct(i,:) = tmp(2:end)';
end;

% Compute PIT for F and each U
f_pit = mean(f_gr_draws_poos < f_gr_mean);
fu_pit = mean(fu_gr_draws_poos < fu_gr_mean);
u_mean_pit = mean(u_gr_mean_draws_poos < u_gr_mean_mean);

tmp = u_gr_draws_poos < repmat(u_gr_mean,1,size(u_gr_draws_poos,2));
u_pit = mean(tmp,2);
tmp = udm_gr_draws_poos < repmat(udm_gr_mean,1,size(udm_gr_draws_poos,2));
udm_pit = mean(tmp,2);


% Select only subset
% Poorest 57 countries (avg 5 years before end of sample)
tmp = mean(yp(Tis-4:Tis,:))';
[aa,ii]=sort(tmp);
ii(58:end) = 0;
i_poor = zeros(n_c,1);
for i = 1:n_c;
    jj = sum(ii==i);
    if jj == 1; i_poor(i) = 1; end;
end;

% u_pit = u_pit(i_poor==1);
% udm_pit = udm_pit(i_poor==1);
% u_gr_draws_poos = u_gr_draws_poos(i_poor==1,:);
% udm_gr_draws_poos = udm_gr_draws_poos(i_poor==1,:);

u_pit = u_pit(i_poor==0);
udm_pit = udm_pit(i_poor==0);
u_gr_draws_poos = u_gr_draws_poos(i_poor==0,:);
udm_gr_draws_poos = udm_gr_draws_poos(i_poor==0,:);


f_pit
u_mean_pit
fu_pit
pvec_u=[mean(u_pit < 0.25);mean((u_pit >= 0.25).*(u_pit < 0.5));mean((u_pit >= 0.50).*(u_pit < 0.75));mean(u_pit >= 0.75)];
pvec_udm=[mean(udm_pit < 0.25);mean((udm_pit >= 0.25).*(udm_pit < 0.5));mean((udm_pit >= 0.50).*(udm_pit < 0.75));mean(udm_pit >= 0.75)];
pvec_u
pvec_udm

% Compute KS Statistic
ks_u = ks_uniform(u_pit);
ks_udm = ks_uniform(udm_pit);

% Compute distribution of test statistics
nrep = size(udm_gr_draws_poos,2);
ks_u_draws = NaN(nrep,1);
ks_udm_draws = NaN(nrep,1);
for i = 1:nrep;
   tmp = u_gr_draws_poos < repmat(u_gr_draws_poos(:,i),1,size(u_gr_draws_poos,2));
   tmp = mean(tmp,2);
   ks_u_draws(i) = ks_uniform(tmp);
   tmp = udm_gr_draws_poos < repmat(udm_gr_draws_poos(:,i),1,size(u_gr_draws_poos,2));
   tmp = mean(tmp,2);
   ks_udm_draws(i) = ks_uniform(tmp);
end;
[ks_u mean(ks_u_draws > ks_u)]
[ks_udm mean(ks_udm_draws > ks_udm)]
    




    



		
	