module compute
!$dir nooptimize	
	use rpmod
	use Sigmod
	use scpcmod
	use clustermod
	implicit none

	integer, parameter	:: nstates=48

	contains
	
	function getstatelocs(istate,lightpower,n,gdens) result(val)
		integer	:: istate,n
		real	:: lightpower,val(2,n)
		real, optional	:: gdens(n)
		
		logical, save	:: initflag=.true.		
		real, allocatable, save	:: mdata(:,:)
		character(len=:),allocatable,save	:: names(:)		
		real, allocatable	:: sdata(:,:)
		real, allocatable	:: dG(:),G(:)
		
		real	:: u(3),s0(2),s(2)
		integer	:: i,j,l
		
		if(initflag) then
			mdata=loadcsv("c:/dropbox/SHAR/data/US_Light_ext.csv")
			names=loadstrings("c:/dropbox/SHAR/data/US_Light_extnames.txt")
			initflag=.false.
		endif
		if(istate>nstates) then
			print *,"getstatelocs encountered state with no data"
			stop
		endif
!		print *,"generating random data from state",istate, names(istate:istate)
		sdata=selectifr(mdata,mdata(:,1)==istate)

		dG=sdata(:,6)
		dG=merge(dG,0.0,isfinite(dG))+1E-100
		dG=dG**lightpower
		G=dG
		do i=2,size(G)
			G(i)=G(i-1)+G(i)
		enddo
		G=G/(0.99999999*G(size(G)))
		do i=1,n
			call rnun(u)
			j=count(u(3)>G)+1
			s0=sdata(j,2:3)+u(1:2)*(sdata(j,4:5)-sdata(j,2:3))
truncnorm:	do
				call rnnoa(s)
				s=s0+0.2*s*(sdata(j,4:5)-sdata(j,2:3))			! now check if s is in some rectangle
				if(all(sdata(j,4:5)-s>0) .and. all(s-sdata(j,2:3)>0)) exit truncnorm
				do l=1,size(G)			
					if(all(sdata(l,4:5)-s>0) .and. all(s-sdata(l,2:3)>0)) exit truncnorm
				enddo
			enddo truncnorm
			val(:,i)=s
			if(present(gdens)) gdens(i)=dG(i)
		enddo
		disttype=0
		val=val/maxval(distmat(val))
	end function

	
	function getmaxcv(W,s,c0) result(val)
		real	:: W(:,:),s(:,:),c0,val
		integer, parameter	:: nc=30
		integer				:: i
		real, parameter	:: cfacs(nc)=exp([(5.0*(i-1.0)/(nc-1),i=1,nc)])
		real, allocatable	:: Sig(:,:),Om(:,:)
		real				:: cvlist(nc)
		integer	:: n,q
		
		n=size(s,2)
		q=size(W,2)
		val=getStudentcv(q,level)
		do i=1,nc
			Sig=getcSig(c0*cfacs(i),s)
			Om=matmul(transpose(W),matmul(Sig,W))
			cvlist(i)=getcv(Om,level)
		enddo
		val=max(val,maxval(cvlist))
	end function		
	
	function getetacv(m,c0) result(val)
		real	:: c0,val
		type(mtype)	:: m
		
		val=getcvfromOms(getOms(m%Weta,m%s,c0),size(m%Weta,2)-1,level)
	end function
	
	subroutine setmfromls(m,m0,ls)
		use rlse_int
		use iercd_int
		type(mtype)	:: m0,m
		integer		:: ls(:)
		integer		:: j,i,cl,mm,l
		real		:: beta(size(m0%Z,2)),sse,sst
		real		:: zss(size(m0%Z,2))
		integer, allocatable	:: izss(:)

		zss=0; mm=0
		do j=1,size(ls)
			cl=ls(j)
			zss=zss+sum(m0%z(m0%clustid(cl):m0%clustid(cl)+m0%nclust(cl)-1,:)**2,dim=1)
			mm=mm+m0%nclust(cl)
		enddo
		izss=pack([(i,i=1,size(m0%Z,2))],zss>0)

		if(.not. allocated(m%x)) then
			m%m=mm;m%n=size(ls)
			allocate(m%x(m%m),m%y(m%m),m%Z(m%m,size(izss)),m%xZ(m%m,size(izss)+1),m%s(2,m%n),m%dxsi(m%n),m%nclust(m%n),m%clustid(m%n))
		elseif (.not.(m%n==size(ls) .and. mm==m%m .and. size(m%Z,2)==size(izss))) then
			deallocate(m%x,m%Z,m%xZ,m%y,m%s,m%dxsi,m%nclust,m%clustid)
			m%m=mm;m%n=size(ls)
			allocate(m%x(m%m),m%y(m%m),m%Z(m%m,size(izss)),m%xZ(m%m,size(izss)+1),m%s(2,m%n),m%dxsi(m%n),m%nclust(m%n),m%clustid(m%n))
		endif
		l=1
		do j=1,size(ls)
			m%clustid(j)=l
			cl=ls(j)
			m%nclust(j)=m0%nclust(cl)
			m%s(:,j)=m0%s(:,cl)
			m%x(m%clustid(j):m%clustid(j)+m%nclust(j)-1)=m0%x(m0%clustid(cl):m0%clustid(cl)+m0%nclust(cl)-1)
			m%y(m%clustid(j):m%clustid(j)+m%nclust(j)-1)=m0%y(m0%clustid(cl):m0%clustid(cl)+m0%nclust(cl)-1)
			m%Z(m%clustid(j):m%clustid(j)+m%nclust(j)-1,:)=m0%Z(m0%clustid(cl):m0%clustid(cl)+m0%nclust(cl)-1,izss)
			l=l+m%nclust(j)
		enddo
		
		call rlse(m%x,m%Z,beta(1:size(izss)),intcep=0,sse=sse,sst=sst)
		if(sse<.01*sst .or. iercd()>0) then
			m%n=-1
			return
		endif
		m%x(:)=m%x-matmul(m%z,beta(1:size(izss)))
		m%xZ(:,:)=m%x.clr.m%Z
		do j=1,m%n
			m%dxsi(j)=sqrt(sum(m%x(m%clustid(j):m%clustid(j)+m%nclust(j)-1)**2))
			if(m%dxsi(j)==0) m%dxsi(j)=1
		enddo
	end subroutine
	
	function robust_avcx(m,avc0,etaflag) result(val)
		type(mtype)	:: m
		logical	:: etaflag
		real	:: avc0,val
		real, dimension(size(m%W,2),size(m%W,2)):: Om
		integer, parameter	:: navcgrid=20
		real	:: rpgrid(5,navcgrid),avcgrid(navcgrid)
		real	:: avc
		integer	:: p,j
	
		if(disttype==1) disttype=2
		avc=avc0
		do j=1,navcgrid
			avcgrid(j)=avc
			avc=avc/1.2
		enddo
!$omp parallel do collapse(2) private(Om,j)		
		do p=-1,3
			do j=1,navcgrid
				call setom(getavc_c(avcgrid(j),p,m%s),p,Om)
				rpgrid(p+2,j)=getrp(Om,1.0)
			enddo
		enddo
		val=maxval(rpgrid)
		if(disttype==2) disttype=1
	contains
	
		subroutine setom(c0,p,Om)
			real	:: c0,Om(:,:)
			integer	:: p
			if(etaflag) then
				Om=getOmfromW(m%Weta,getcpSig(c0,p,m%s))
			else
				if(m%m>m%n) then
					Om=getOmfromW(m%Wx,geteSig(m,getcpSig(c0,p,m%s)))
				else
					Om=getOmfromW(m%Wx,getcpSig(c0,p,m%s))
				endif
			endif
		end subroutine
	end function

end module