module runmod
!!dir$ nooptimize	
	use compute
	use scpcmod
	implicit none
	
	integer, parameter	:: nsim=5000
	real, parameter		:: avc0=0.03
	real, allocatable	:: CSCPC_Sigs(:,:,:)
	logical				:: pflag=.true.
	character(len=20)	:: dgpname
	
	contains
	
	subroutine printquantiles(RPs,name)
		real	:: RPs(:,:,:)
		character(len=*)	:: name
		integer, parameter	:: nqs=3
		real, parameter	:: qs(nqs)=[.05,.5,.95]
		real	:: RPq(size(RPs,1),size(RPs,2),nqs)
		integer	:: i,j
		do i=1,size(RPs,1)
			do j=1,size(RPs,2)
				RPq(i,j,:)=quantile_v(RPs(i,j,:),qs)
			enddo
		enddo
		do i=1,nqs
			print *,nint(100*qs(i)),"th percentile"
			call mdisp(RPq(:,:,i))
			call savematcsv("c:/dropbox/mystuff/spatialUR/out/new/"//trim(dgpname)//"_"//trim(name)//"_"//convtos(nint(100*qs(i)))//".csv",RPq(:,:,i))
		enddo
	end subroutine
	
	function getHRs2(x,nc,clustid) result(val)
		real	:: x(:),val
		integer	:: nc,clustid(:)
		real	:: v(nc)
		integer	:: j
		v=0
		do j=1,size(x)
			v(clustid(j))=v(clustid(j))+x(j)
		enddo
		val=sum(v**2)
	end function
	
	subroutine clusterFE(iflag,s,y,xZ)
		use rlse_int
		use tin_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)
		
		character(len=15), parameter	:: name="cluster FE"
		integer, parameter	:: nncs=4, ncs(nncs)=[30,60,120,240]
		integer, save	:: n,k
		real, save	:: RP(6,nncs,nsim) 
		real, save, allocatable	:: RPs(:,:,:)
		type scpc_type
			integer	:: q,n
			real	:: cv,c0
			integer, allocatable:: clustid(:),clustn(:)
			real, allocatable	:: s(:,:), W(:,:),Sigs(:,:,:)
		end type
		type(scpc_type), save	:: sd(nncs)
		integer, allocatable, save	:: clustids(:,:)
		
		integer	:: j,i,nc,l
		real	:: yt(size(y)),xZt(size(xZ,1),size(xZ,2)),e(size(y)),del,s2,b(size(xZ,2)),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:)
		
		if(iflag==-1) then
			if(allocated(RPs)) deallocate(RPs)
			allocate(RPs(size(RP,1),size(RP,2),0))
		endif
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			do j=1,nncs
				nc=ncs(j)
				if(allocated(sd(j)%s)) deallocate(sd(j)%s,sd(j)%clustid,sd(j)%clustn)
				allocate(sd(j)%s(2,nc),sd(j)%clustid(n),sd(j)%clustn(nc))
				call setclusters_kmeans(s,nc,sd(j)%clustid,sd(j)%s)
				do i=1,nc
					sd(j)%clustn(i)=count(sd(j)%clustid==i)
				enddo
				sd(j)%c0=getavc_c(0.03,0,sd(j)%s)
				sd(j)%W=getWeigen(getcSig(sd(j)%c0,sd(j)%s),min(qmax,nc-1))
				call setSCPCqcv(sd(j)%W,sd(j)%s,sd(j)%c0,sd(j)%q,sd(j)%cv)
				sd(j)%Sigs=getOmsSigs(sd(j)%s,sd(j)%c0)
			enddo
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			do j=1,nncs
				nc=ncs(j)
				yt=y
				xZt=xZ
				do i=1,nc
					where(sd(j)%clustid==i) yt=yt-sum(yt,mask=sd(j)%clustid==i)/sd(j)%clustn(i)
					do l=1,k
						where(sd(j)%clustid==i) xzt(:,l)=xzt(:,l)-sum(xzt(:,l),mask=sd(j)%clustid==i)/sd(j)%clustn(i)
					enddo
				enddo
				if(k>1) then
					call rlse(xZt(:,1),xZt(:,2:k),b(2:k),intcep=0)
					xZt(:,1)=xZt(:,1)-matmul(xZt(:,2:k),b(2:k))
				endif
				
				call rlse(yt,xZt,b,intcep=0)
				s2=getHRs2((yt-matmul(xZt,b))*xZt(:,1),nc,sd(j)%clustid)
				RP(1,j,iflag)=boole(sum(xZt(:,1)*yt)**2>1.96**2*s2)
				RP(2,j,iflag)=2*1.96*sqrt(s2)/sum(xZt(:,1)**2)
				
				if(allocated(Wx)) deallocate(Wx,Weta)
				allocate(Wx(n,size(sd(j)%W,2)),Weta(nc,size(sd(j)%W,2)))
				call setWxeta_clust(sd(j)%W,xZt,Wx,Weta,nc,sd(j)%clustid)
				
				s2=sum(matmul(yt,Wx(:,2:))**2)
				RP(3,j,iflag)=boole(sum(Wx(:,1)*yt)**2>sd(j)%cv**2*s2)
				RP(4,j,iflag)=2*sd(j)%cv*sqrt(s2)/sum(xZt(:,1)**2)

				ccv=getcvfromOms(getOmsfromSigs(Weta,sd(j)%Sigs),size(Weta,2)-1,level)				
				ccv=max(sd(j)%cv,ccv)
				RP(5,j,iflag)=boole(sum(Wx(:,1)*yt)**2>ccv**2*s2)
				RP(6,j,iflag)=2*ccv*sqrt(s2)/sum(xZt(:,1)**2)
			enddo
		endif
		if(iflag==nsim+1) then
			RPs=reshape([RPs,sum(RP,dim=3)/nsim],[size(RP,1),size(RP,2),size(RPs,3)+1])
			if(pflag) then
				print *,name
				call mdisp(RPs(:,:,size(RPs,3)))
			endif
		endif
		if(iflag==nsim+2) then
			print *,name
			call printquantiles(RPs,"clustFE")
		endif
	end subroutine
	
	subroutine IMkmeans(iflag,s,y,xZ)
		use rlse_int
		use tin_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)

		character(len=25), parameter	:: name="Ibragimov-Mueller"
		integer, parameter	:: nqs=3, qs(nqs)=[10,20,50]
		integer, save	:: n,k
		real, save	:: RP(2,nqs,nsim)
		real, save, allocatable	:: RPs(:,:,:)
		integer, allocatable, save	:: clustids(:,:)
		
		real, save	:: cvs(nqs)
		
		integer	:: j,i,q
		real	:: del,s2,b(size(xZ,2)+1),betas(maxval(qs)),bhat
		real, allocatable	:: yt(:),xZt(:,:)

		if(iflag==-1) then
			if(allocated(RPs)) deallocate(RPs)
			allocate(RPs(size(RP,1),size(RP,2),0))
		endif
		
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			if(allocated(clustids)) deallocate(clustids)
			allocate(clustids(n,nqs))
			do j=1,nqs
				call setclusters_kmeans(s,qs(j),clustids(:,j))
				cvs(j)=tin(0.975,real(qs(j)))
			enddo
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			do j=1,nqs
				q=qs(j)
				do i=1,q
					yt=pack(y,clustids(:,j)==i)
					if(size(yt)<=k+1) then
						betas(i)=0
						cycle
					endif
					xZt=selectifr(xZ,clustids(:,j)==i)
					call rlse(yt,xZt,b,intcep=1)
					betas(i)=b(2)
				enddo
				bhat=sum(betas(1:q))/q
				s2=sum((betas(1:q)-bhat)**2)/(q-1)
				RP(1,j,iflag)=boole(bhat**2>cvs(j)**2*s2/q)
				RP(2,j,iflag)=2*cvs(j)*sqrt(s2/q)
			enddo
		endif
		if(iflag==nsim+1) then
			RPs=reshape([RPs,sum(RP,dim=3)/nsim],[size(RP,1),size(RP,2),size(RPs,3)+1])
			if(pflag) then
				print *,name
				call mdisp(RPs(:,:,size(RPs,3)))
			endif
		endif
		if(iflag==nsim+2) then
			print *,name
			call printquantiles(RPs,"IM")
		endif
	end subroutine
	
	subroutine regR2(iflag,s,y,xZ)
		use rlse_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)

		character(len=25), parameter	:: name="R2"
		integer, save	:: q,n,k
		real, save	:: RP(1,1,nsim)
		real, save, allocatable	:: RPs(:,:,:)
		real, save	:: c0,cv
		
		integer	:: j
		real	:: del,yt(size(y)),xZt(size(xZ,1),size(xZ,2)+1),s2,b(size(xZ,2)+1),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:)
		
		if(iflag==-1) then
			if(allocated(RPs)) deallocate(RPs)
			allocate(RPs(size(RP,1),size(RP,2),0))
		endif
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			xZt(:,1:k)=xZ
			xZt(:,k+1)=1
			yt=y-sum(y)/n
			call rlse(yt,xZt,b,intcep=0)
			RP(1,1,iflag)=1-sum((yt-matmul(xZt,b))**2)/sum(yt**2)
		endif
		if(iflag==nsim+1) then
			RPs=reshape([RPs,sum(RP,dim=3)/nsim],[size(RP,1),size(RP,2),size(RPs,3)+1])
			if(pflag) then
				print *,name
				call mdisp(RPs(:,:,size(RPs,3)))
			endif
		endif
		if(iflag==nsim+2) then
			print *,name
			call printquantiles(RPs,"R2")
		endif
	end subroutine

	
	subroutine sqrtGLS(iflag,s,y,xZ)
		use rlse_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)

		character(len=25), parameter	:: name="FGLS with SCPC"
		real, parameter	:: weights(1)=[0.0] ![0.0,.2,.4,.6,.8]
		integer, save	:: q,n,k
		real, save	:: RP(6,size(weights),nsim)
		real, save, allocatable	:: RPs(:,:,:)
		real, allocatable, save	:: Asqrts(:,:,:),W(:,:)
		real, save	:: c0,cv
		
		integer	:: j
		real	:: del,yt(size(y)),xZt(size(xZ,1),size(xZ,2)),s2,b(size(xZ,2)),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:),A(:,:)
		
		if(iflag==-1) then
			if(allocated(RPs)) deallocate(RPs)
			allocate(RPs(size(RP,1),size(RP,2),0))
		endif
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			if(allocated(Asqrts)) deallocate(Asqrts)
			allocate(Asqrts(n,n,size(weights)))

			do j=1,size(weights)
				A=getLevySig(s)
				A=A+trace(A)*weights(j)/(n*(1-weights(j)))*eye(n)
				Asqrts(:,:,j)=matinvsqrt(demeanedSig(A))
			enddo
			c0=getavc_c(0.03,0,s)
			W=getWeigen(getcSig(c0,s),qmax)
			call setSCPCqcv(W,s,c0,q,cv)
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			allocate(Wx,Weta,mold=W)
			do j=1,size(weights)
				xZt=matmul(Asqrts(:,:,j),xZ)
				yt=matmul(Asqrts(:,:,j),y)
				if(k>1) then
					call rlse(xZt(:,1),xZt(:,2:k),b(2:k),intcep=0)
					xZt(:,1)=xZt(:,1)-matmul(xZt(:,2:k),b(2:k))
				endif
			
				call rlse(yt,xZt,b,intcep=0)
				s2=sum(((yt-matmul(xZt,b))*xZt(:,1))**2)
				RP(1,j,iflag)=boole(sum(xZt(:,1)*yt)**2>1.96**2*s2)
				RP(2,j,iflag)=2*1.96*sqrt(s2)/sum(xZt(:,1)**2)
			
				call setWxeta(W,xZt,Wx,Weta)
				s2=sum(matmul(yt,Wx(:,2:))**2)
				RP(3,j,iflag)=boole(sum(Wx(:,1)*yt)**2>cv**2*s2)
				RP(4,j,iflag)=2*cv*sqrt(s2)/sum(xZt(:,1)**2)

				ccv=getcvfromOms(getOmsfromSigs(Weta,CSCPC_Sigs),size(Weta,2)-1,level)				
				ccv=max(cv,ccv)
				RP(5,j,iflag)=boole(sum(Wx(:,1)*yt)**2>ccv**2*s2)
				RP(6,j,iflag)=2*ccv*sqrt(s2)/sum(xZt(:,1)**2)
			enddo
		endif
		if(iflag==nsim+1) then
			RPs=reshape([RPs,sum(RP,dim=3)/nsim],[size(RP,1),size(RP,2),size(RPs,3)+1])
			if(pflag) then
				print *,name
				call mdisp(RPs(:,:,size(RPs,3)))
			endif
		endif
		if(iflag==nsim+2) then
			print *,name
			call printquantiles(RPs,"FGLS")
		endif
	end subroutine

	function getisodiffA(s,del) result(val)
		real	:: s(:,:),del,val(size(s,2),size(s,2))
		integer	:: i,j,n
		real	:: c
		n=size(s,2)
		do i=1,n
			c=0
			do j=1,n
				if(i==j) cycle
				if(norm2(s(:,j)-s(:,i))>del) then
					val(i,j)=0
				else
					val(i,j)=norm2(s(:,j)-s(:,i))**(-0.5)
					c=c+val(i,j)
				endif
			enddo
			if(c==0) then
				val(i,i)=0
			else
!				val(i,:)=val(i,:)
				val(i,i)=-c
			endif
		enddo
	end function
	
	subroutine isodiff(iflag,s,y,xZ)
		use rlse_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)
		integer, parameter	:: ndels=5

		character(len=25), parameter	:: name="isotropic differences"
		integer, save	:: q,n,k
		real, save	:: RP(4,ndels,nsim)
		real, save, allocatable	:: RPs(:,:,:)
		real, allocatable, save	:: As(:,:,:),W(:,:)
		real, save	:: c0,cv
		
		integer	:: j
		real	:: del,yt(size(y)),xZt(size(xZ,1),size(xZ,2)),s2,b(size(xZ,2)),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:)
		
		if(iflag==-1) then
			if(allocated(RPs)) deallocate(RPs)
			allocate(RPs(size(RP,1),size(RP,2),0))
		endif
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			if(allocated(As)) deallocate(As,W)
			allocate(As(n,n,ndels))
			do j=1,ndels
				del=.03*j
				As(:,:,j)=getisodiffA(s,del)
				if(maxval(abs(As(:,:,j)))==0) then
					print *,"no locations within delta"
					stop
				endif
			enddo
			c0=getavc_c(0.03,0,s)
			W=getWeigen(getcSig(c0,s),qmax)
			call setSCPCqcv(W,s,c0,q,cv)
			RP=0
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			allocate(Wx,Weta,mold=W)
			do j=1,ndels
				xZt=matmul(As(:,:,j),xZ)
				yt=matmul(As(:,:,j),y)
				if(k>1) then
					call rlse(xZt(:,1),xZt(:,2:k),b(2:k),intcep=0)
					xZt(:,1)=xZt(:,1)-matmul(xZt(:,2:k),b(2:k))
				endif
				call setWxeta(W,xZt,Wx,Weta)
				s2=sum(matmul(yt,Wx(:,2:))**2)
				RP(1,j,iflag)=boole(sum(Wx(:,1)*yt)**2>cv**2*s2)
				RP(2,j,iflag)=2*cv*sqrt(s2)/sum(xZt(:,1)**2)
!cycle
				ccv=getcvfromOms(getOmsfromSigs(Weta,CSCPC_Sigs),size(Weta,2)-1,level)				
				ccv=max(cv,ccv)
				RP(3,j,iflag)=boole(sum(Wx(:,1)*yt)**2>ccv**2*s2)
				RP(4,j,iflag)=2*ccv*sqrt(s2)/sum(xZt(:,1)**2)
			enddo
		endif
		if(iflag==nsim+1) then
			RPs=reshape([RPs,sum(RP,dim=3)/nsim],[size(RP,1),size(RP,2),size(RPs,3)+1])
			if(pflag) then
				print *,name
				call mdisp(RPs(:,:,size(RPs,3)))
			endif
		endif
		if(iflag==nsim+2) then
			print *,name
			call printquantiles(RPs,"isodiff")
		endif
	end subroutine
	
	subroutine lfi(iflag,s,y,xZ)
		use rlse_int
		use tin_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)
		integer, parameter	:: nqs=3, qs(nqs)=[10,20,50]
		
		character(len=25), parameter	:: name="low-frequency regression"
		integer, save	:: n,k
		real, save	:: RP(2,nqs,nsim),cvs(nqs)
		real, save, allocatable	:: RPs(:,:,:)
		real, allocatable, save	:: W(:,:)
		
		integer	:: j
		real	:: s2,b(size(xZ,2))
		real, allocatable	::  yt(:),xZt(:,:)
		
		if(iflag==-1) then
			if(allocated(RPs)) deallocate(RPs)
			allocate(RPs(size(RP,1),size(RP,2),0))
		endif
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			do j=1,nqs
				cvs(j)=tin(0.975,real(qs(j)-k))
			enddo
			W=getWlfi(getLevySig(s),maxval(qs))
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			do j=1,nqs
				xZt=matmul(transpose(W(:,1:qs(j))),xZ)
				if(k>1) then
					call rlse(xZt(:,1),xZt(:,2:k),b(2:k),intcep=0)
					xZt(:,1)=xZt(:,1)-matmul(xZt(:,2:k),b(2:k))
				endif
				yt=matmul(transpose(W(:,1:qs(j))),y)
				call rlse(yt,xZt,b,intcep=0)				
				s2=(sum((yt-matmul(xZt,b))**2)/(qs(j)-k))/sum(xZt(:,1)**2)
				
				RP(1,j,iflag)=boole(b(1)**2>cvs(j)**2*s2)
				RP(2,j,iflag)=2*cvs(j)*sqrt(s2)
			enddo
		endif
		if(iflag==nsim+1) then
			RPs=reshape([RPs,sum(RP,dim=3)/nsim],[size(RP,1),size(RP,2),size(RPs,3)+1])
			if(pflag) then
				print *,name
				call mdisp(RPs(:,:,size(RPs,3)))
			endif
		endif
		if(iflag==nsim+2) then
			print *,name
			call printquantiles(RPs,"lfreg")
		endif
	end subroutine

	function getWlfi(Sig,q) result(val)
		use evesf_int
		real	:: Sig(:,:)
		integer	:: q
		real	:: c,val(size(Sig,1),q)
		real	:: Sigm(size(Sig,1),size(Sig,1)),evs(q)
		integer	:: i,n
		n=size(Sig,1)
		do i=1,n
			Sigm(:,i)=Sig(:,i)-sum(Sig(:,i))/n
		enddo
		do i=1,n
			Sigm(i,:)=Sigm(i,:)-sum(Sigm(i,:))/n
		enddo
		call evesf(q,Sigm,.false.,evs,val)
		do i=1,q
			val(:,i)=val(:,i)/sqrt(evs(i))
		enddo
	end function
	
	subroutine URtest(iflag,s,y,xZ)
		use rlse_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)
		integer, parameter	:: nms=2
		integer, parameter	:: ms(nms)=[q_small,q_large]

		character(len=25), parameter	:: name="URtests"
		integer, save	:: q,n,k
		real, save	:: RP(1,nms,nsim)
		real, save, allocatable	:: RPs(:,:,:)
		real, save		:: Oms(q_small,q_small,2),Omse(q_large,q_large,2)
		real, allocatable, save	:: W(:,:)
		real			:: yr(q_large)
		integer	:: j,l0
		
		if(iflag==-1) then
			if(allocated(RPs)) deallocate(RPs)
			allocate(RPs(size(RP,1),size(RP,2),0))
		endif
		if(iflag==0) then
			call setURtest(s,W,Oms,Omse)
			RP=0
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			yr=matmul(transpose(W),y)
			RP(1,2,iflag)=boole(sum(yr*matmul(Omse(:,:,1),yr))/sum(yr*matmul(Omse(:,:,2),yr))>1) 
			RP(1,1,iflag)=boole(sum(yr(1:q_small)*matmul(Oms(:,:,1),yr(1:q_small)))/sum(yr(1:q_small)*matmul(Oms(:,:,2),yr(1:q_small)))>1) 
		endif
		if(iflag==nsim+1) then
			RPs=reshape([RPs,sum(RP,dim=3)/nsim],[size(RP,1),size(RP,2),size(RPs,3)+1])
			if(pflag) then
				print *,name
				call mdisp(RPs(:,:,size(RPs,3)))
			endif
		endif
		if(iflag==nsim+2) then
			print *,name
			call printquantiles(RPs,"URtests")
		endif
	end subroutine
	
	subroutine lowpass(iflag,s,y,xZ)
		use rlse_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)
		integer, parameter	:: nms=5
		integer, parameter	:: ms(nms)=[5,10,20,50,100]

		character(len=25), parameter	:: name="low pass"
		integer, save	:: q,n,k
		real, save	:: RP(4,nms,nsim)
		real, save, allocatable	:: RPs(:,:,:)
		real, allocatable, save	:: As(:,:,:),W(:,:)
		real, save	:: c0,cv
		
		integer	:: j
		real	:: del,yt(size(y)),xZt(size(xZ,1),size(xZ,2)),s2,b(size(xZ,2)),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:)
		
		if(iflag==-1) then
			if(allocated(RPs)) deallocate(RPs)
			allocate(RPs(size(RP,1),size(RP,2),0))
		endif
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			if(allocated(As)) deallocate(As,W)
			allocate(As(n,n,nms))
			W=getWeigen(getLevySig(s),maxval(ms))
			W=W(:,2:)
			do j=1,nms
				As(:,:,j)=(eye(n)-(1.0/n))-matmul(W(:,1:ms(j)),transpose(W(:,1:ms(j))))
			enddo
			c0=getavc_c(0.03,0,s)
			W=getWeigen(getcSig(c0,s),qmax)
			call setSCPCqcv(W,s,c0,q,cv)
			RP=0
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			allocate(Wx,Weta,mold=W)
			do j=1,nms
				xZt=matmul(As(:,:,j),xZ)
				yt=matmul(As(:,:,j),y)
				if(k>1) then
					call rlse(xZt(:,1),xZt(:,2:k),b(2:k),intcep=0)
					xZt(:,1)=xZt(:,1)-matmul(xZt(:,2:k),b(2:k))
				endif
				call setWxeta(W,xZt,Wx,Weta)
				s2=sum(matmul(yt,Wx(:,2:))**2)
				RP(1,j,iflag)=boole(sum(Wx(:,1)*yt)**2>cv**2*s2)
				RP(2,j,iflag)=2*cv*sqrt(s2)/sum(xZt(:,1)**2)

				ccv=getcvfromOms(getOmsfromSigs(Weta,CSCPC_Sigs),size(Weta,2)-1,level)				
				ccv=max(cv,ccv)
				RP(3,j,iflag)=boole(sum(Wx(:,1)*yt)**2>ccv**2*s2)
				RP(4,j,iflag)=2*ccv*sqrt(s2)/sum(xZt(:,1)**2)
			enddo
		endif
		if(iflag==nsim+1) then
			RPs=reshape([RPs,sum(RP,dim=3)/nsim],[size(RP,1),size(RP,2),size(RPs,3)+1])
			if(pflag) then
				print *,name
				call mdisp(RPs(:,:,size(RPs,3)))
			endif
		endif
		if(iflag==nsim+2) then
			print *,name
			call printquantiles(RPs,"lowpass")
		endif
	end subroutine

	subroutine notrans(iflag,s,y,xZ)
		use rlse_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)

		character(len=25), parameter	:: name="levels"
		integer, parameter	:: nncs=4, ncs(nncs)=[30,60,120,240]
		integer, allocatable, save	:: clustids(:,:)
		
		integer, save	:: q,n,k
		real, save	:: RP(6,nncs,nsim)
		real, save, allocatable	:: RPs(:,:,:)
		real, allocatable, save	:: W(:,:)
		real, save	:: c0,cv
		
		integer	:: j
		real	:: del,yt(size(y)),xZt(size(xZ,1),size(xZ,2)+1),s2,b(size(xZ,2)+1),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:)
		
		if(iflag==-1) then
			if(allocated(RPs)) deallocate(RPs)
			allocate(RPs(size(RP,1),size(RP,2),0))
		endif
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			c0=getavc_c(0.03,0,s)
			W=getWeigen(getcSig(c0,s),qmax)
			call setSCPCqcv(W,s,c0,q,cv)
			RP=0
			if(allocated(clustids)) deallocate(clustids)
			allocate(clustids(n,nncs))
			do j=1,nncs
				call setclusters_kmeans(s,ncs(j),clustids(:,j))
			enddo
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			j=1
			allocate(Wx,Weta,mold=W)
			xZt(:,1:k)=xZ
			xZt(:,k+1)=1
			call rlse(xZt(:,1),xZt(:,2:),b(2:),intcep=0)
			xZt(:,1)=xZt(:,1)-matmul(xZt(:,2:),b(2:))
			call setWxeta(W,xZt,Wx,Weta)
			yt=y
			s2=sum(matmul(yt,Wx(:,2:))**2)
			RP(1,:,iflag)=boole(sum(Wx(:,1)*yt)**2>cv**2*s2)
			RP(2,:,iflag)=2*cv*sqrt(s2)/sum(xZt(:,1)**2)
			
			ccv=getcvfromOms(getOmsfromSigs(Weta,CSCPC_Sigs),size(Weta,2)-1,level)				
			ccv=max(cv,ccv)
			RP(3,:,iflag)=boole(sum(Wx(:,1)*yt)**2>ccv**2*s2)
			RP(4,:,iflag)=2*ccv*sqrt(s2)/sum(xZt(:,1)**2)
			
			call rlse(yt,xZt,b,intcep=0)
			do j=1,nncs
				s2=getHRs2((yt-matmul(xZt,b))*xZt(:,1),ncs(j),clustids(:,j))
				RP(5,j,iflag)=boole(sum(xZt(:,1)*yt)**2>1.96**2*s2)
				RP(6,j,iflag)=2*1.96*sqrt(s2)/sum(xZt(:,1)**2)
			enddo
		endif
		if(iflag==nsim+1) then
			RPs=reshape([RPs,sum(RP,dim=3)/nsim],[size(RP,1),size(RP,2),size(RPs,3)+1])
			if(pflag) then
				print *,name
				call mdisp(RPs(:,:,size(RPs,3)))
			endif
		endif
		if(iflag==nsim+2) then
			print *,name
			call printquantiles(RPs,"levels")
		endif
	end subroutine
	
	subroutine runMC
		integer, parameter	:: n=400
		integer	:: l,istate,k,i,im,ic
		real, allocatable	:: s(:,:),Sig0(:,:),chol0(:,:),xZ(:,:),y(:)
		real	:: c0
		character(len=40)	:: modelname

		pflag=.false.
		do k=1,5,4
		do im=1,7,6
			if(allocated(y)) deallocate(y,xZ)
			allocate(y(n),xZ(n,k))
			s=getstatelocs(1,0.0,n)
			call go(-1,s,y,xZ)
			do ic=1,2
			do istate=1,3+0*nstates
				s=getstatelocs(istate,0.0,n)
				c0=getavc_c(0.03,0,s)
				CSCPC_Sigs=getOmsSigs(s,c0)
	!			print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
	!			print *,"c0=",c0
				select case(im)
					case(1)
						Sig0=getLevySig(s)
						modelname="pure Levy"
						dgpname="Levy_k"//convtos(k)
						
					case(2)
						Sig0=getI1Sig(s,c0)
						modelname="I1 with c_0.03"
						dgpname="I1003_k"//convtos(k)
					case(3)
						c0=getavc_c(0.01,0,s)
						Sig0=getI1Sig(s,c0)
						modelname="I1 with c_0.01"
						dgpname="I1001_k"//convtos(k)
					case(4)
						c0=getavc_c(0.50,0,s)
						Sig0=getcSig(c0,s)
						modelname="pure LTU with c_0.50"
						dgpname="LTU500_k"//convtos(k)
					case(5)
						Sig0=getBMSig(s)
						modelname="pure Brownian sheet"
						dgpname="Bsheet_k"//convtos(k)
					case(6)
						c0=getavc_c(0.03,2,s)
						Sig0=getI1matSig(s,c0)
						modelname="I1 with Matern B (nu=2.5) and c_0.03"
						dgpname="I1mat_k"//convtos(k)
					case(7)
						c0=getavc_c(0.2,0,s)
						Sig0=getcSig(c0,s)
						modelname="pure LTU with c_0.03"
						dgpname="LTU003_k"//convtos(k)
				end select
				chol0=robchol(Sig0)
				call go(0,s,y,xZ)
!$omp parallel do private(i) firstprivate(y,xZ)
				do l=1,nsim
					call rnnoa(y)
					y=matmul(chol0,y)
					do i=1,k
						call rnnoa(xZ(:,i))
						xZ(:,i)=matmul(chol0,xZ(:,i))
					enddo
					call go(l,s,y,xZ)
				enddo
				call go(nsim+1,s,y,xZ)
			enddo
			enddo
			print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
			print *,"XXXXXXXXXX k=",k,"  ",modelname
			print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
			call go(nsim+2,s,y,xZ)
			call printtime
		enddo
		enddo
	
	end subroutine
		
	subroutine go(l,s,y,xZ)
		integer	:: l
		real	:: s(:,:),y(:),xz(:,:)
		call regR2(l,s,y,xZ)
		call notrans(l,s,y,xZ)
		call isodiff(l,s,y,xZ)
		call lfi(l,s,y,xZ)
		call IMkmeans(l,s,y,xZ)
		call clusterFE(l,s,y,xZ)
		call sqrtGLS(l,s,y,xZ)
		call lowpass(l,s,y,xZ)
	end subroutine
	
	
end module
	
	
program mfort
	use runmod
	implicit none
	integer	:: i

	call initmaterngrid
	call rnset(14)
!$omp parallel do
	do i=1,100
		call rnset(49184*i)
	enddo

	call inittime
		
	call mkGQxw(GQxw)
	
	call runMC

end program