% Tables for MC results

clear all;
small = 1.0e-10;
big = 1.0e+8;
global datadir

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
datdir = '../um_mc/';
addpath('../matlab_functions');

% List Designs
Design_lst = {'Levy';'I1001';'I1003';'I1mat';'LTU003';'LTU500';'Bsheet'};
k_lst = {'k1';'k5'};
% Note: lfreg is low-pass eigenvector; lowpass is high-pass eigenvector
pct_lst = {'5';'50';'95'};
n_design = length(Design_lst);
ols_cscpc = NaN(2,n_design);
iso_cscpc = NaN(2,n_design);
cfe_cscpc = NaN(2,n_design);
cfe_cluster = NaN(2,n_design);
lbmgls_hr = NaN(2,n_design);
lbmgls_cscpc = NaN(2,n_design);
lpe = NaN(2,n_design);
hpe_cscpc = NaN(2,n_design);
im = NaN(2,n_design);
r2 = NaN(1,n_design);

% Documentation for file structure
%{
This documents the rows and cols for each method
The rows come in pairs, first entry is size, second entry is lenght of CI
The columns denote the various (m,b,q) parameters used ...

Levels:  This is OLS estimate .. 
	The rows (in pairs) are (1) SCPC, (2) C-SCPC, (3) Clustered SEs
	The columns index cluster size (m=30, 60, 120, 240)
	Note the column entries for the first 2 sets of rows are identical (no clusters).
	
ClustFE:  This is cluster fixed effect estimator 
	The rows (in pairs) are (1) Clustered SEs (2) SCPC, (3) C-SCPC
	The columns index cluster size (m=30, 60, 120, 240)

FGLS: This is the LMB-GLS estimator
	The rows (in pairs) are (1) HR (2) SCPC, (3) C-SCPC
	Their is a single column

IM: This is Ibragimov-Mueller
	There is one row (a pair)
	The columns index the number of regions (m=10, 20, 50

isodiff: This is the isotropic difference estimator
	The rows (in pairs) index (1) SCPC and (2) C-SCPC)
	The columns index the value of b for the kernel  b = (0.03, 0.06,0.09,0.12 and 0.15)

lfreq: This is the Low-pass eigenvalue Transformation
	There is one (pair) row
	The columns index q with q = (10, 20, 50,100)
	
lowpass: This is the high-pass eigenvalue tranformation. (Note that the label is misleading)
	There are two (pairs) rows. The first is SCPC. The second is CSCPC
	The columns index q with q = (5, 10, 20, 50)

R2: This is the R2 in the levels regression
	There is a single row
	
%}

% Relevant Rows to choose from files
ols_cscpc_row = 2;    % C-SCPC
iso_cscpc_row = 2;    % C-SCPC
cfe_cscpc_row = 3;    % C-SCPC
cfe_cluster_row = 1;  % Clustered SEs
lbmgls_hr_row = 1;    % HR
lbmgls_cscpc_row = 3; % C-SCPC
lpe_row = 1;
hpe_cscpc_row = 2;
im_row = 1;

for ik = 1:2

if ik == 1
 kstr = 'k1';
elseif ik ==2
 kstr = 'k5';   
end

 for id = 1:n_design
   dstr = char(Design_lst(id));
   ols_cscpc(:,id) = choose_cols('levels',ols_cscpc_row,datdir,dstr,kstr);
   iso_cscpc(:,id) = choose_cols('isodiff',iso_cscpc_row,datdir,dstr,kstr);
   cfe_cscpc(:,id) = choose_cols('clustFE',cfe_cscpc_row,datdir,dstr,kstr);
   cfe_cluster(:,id) = choose_cols('clustFE',cfe_cluster_row,datdir,dstr,kstr);
   lbmgls_hr(:,id) = choose_cols('FGLS',lbmgls_hr_row,datdir,dstr,kstr);
   lbmgls_cscpc(:,id) = choose_cols('FGLS',lbmgls_cscpc_row,datdir,dstr,kstr);
   lpe(:,id) = choose_cols('lfreg',lpe_row,datdir,dstr,kstr);
   hpe_cscpc(:,id) = choose_cols('lowpass',hpe_cscpc_row,datdir,dstr,kstr);
   im(:,id) = choose_cols('IM',im_row,datdir,dstr,kstr);
   fname = [datdir dstr '_' kstr '_R2_50'];
   tmp = readmatrix(fname);
   r2(:,id)=tmp;
 end
 
 % Create Table
 outfile_name = [outdir 'um_mc_tab_size_' kstr '.csv'];
 fileID = fopen(outfile_name,'w');
 fprintf(fileID,'Method, ');
 for id = 1:n_design
        dstr = char(Design_lst(id));
        fprintf(fileID,dstr);
        if id == n_design
            fprintf(fileID,' \n');
        else
            fprintf(fileID,' ,');
        end
 end

 fprintf(fileID,'OLS (C-SCPC,');
 tmp = ols_cscpc(1,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'isodiff (C-SCPC),');
 tmp = iso_cscpc(1,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'cluster fe (Cluster),');
 tmp = cfe_cluster(1,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'cluster fe (CSCPC),');
 tmp = cfe_cscpc(1,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'LBM-GLS,');
 tmp = lbmgls_hr(1,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'LBM-GLS (C-SCPC),');
 tmp = lbmgls_cscpc(1,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'lp_eig,');
 tmp = lpe(1,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'hp_cscpc_eig,');
 tmp = hpe_cscpc(1,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'IM,');
 tmp = im(1,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'R2,');
 tmp = r2;
 prt_tmp(tmp,fileID);

% Create Table
outfile_name = [outdir 'um_mc_tab_length_' kstr '.csv'];
fileID = fopen(outfile_name,'w');
fprintf(fileID,'Method, ');
for id = 1:n_design
        dstr = char(Design_lst(id));
        fprintf(fileID,dstr);
        if id == n_design
            fprintf(fileID,' \n');
        else
            fprintf(fileID,' ,');
        end
end

%  fprintf(fileID,'OLS (C-SCPC,');
%  tmp = ols_cscpc(2,:);
%  prt_tmp(tmp,fileID);

 fprintf(fileID,'isodiff (C-SCPC),');
 tmp = iso_cscpc(2,:);
 prt_tmp(tmp,fileID);

%  fprintf(fileID,'cluster fe (Cluster),');
%  tmp = cfe_cluster(2,:);
%  prt_tmp(tmp,fileID);

 fprintf(fileID,'cluster fe (CSCPC),');
 tmp = cfe_cscpc(2,:);
 prt_tmp(tmp,fileID);

%  fprintf(fileID,'LBM-GLS,');
%  tmp = lbmgls_hr(2,:);
%  prt_tmp(tmp,fileID);

 fprintf(fileID,'LBM-GLS (C-SCPC),');
 tmp = lbmgls_cscpc(2,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'lp_eig,');
 tmp = lpe(2,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'hp_cscpc_eig,');
 tmp = hpe_cscpc(2,:);
 prt_tmp(tmp,fileID);

 fprintf(fileID,'IM,');
 tmp = im(2,:);
 prt_tmp(tmp,fileID);

 
end


% Functions
function [rslt] = choose_cols(estr,i_row,datdir,dstr,kstr)
   % Get Results 50th percentile
   fname = [datdir dstr '_' kstr '_' estr '_50'];
   tmp = readmatrix(fname);
   jj = 1 + 2*(i_row-1);
   sz = tmp(jj,:)';
   [~,ii]=min(abs(sz-0.05));
   rslt = tmp(jj:jj+1,ii);
 end



function prt_tmp(tmp,fileID)
n_design = length(tmp);
for id = 1:n_design
        fprintf(fileID,'%5.2f',tmp(id));
        if id == n_design
            fprintf(fileID,' \n');
        else
            fprintf(fileID,' ,');
        end
end

end

