function [cv_eta] = get_cv_eta(x,r,Z,rhobar,distmat,alpha)
 V = [x Z];
 n = size(x,1);
 q = size(r,2);
 sgn_x = (x >= 0) - (x < 0);
 W_eta_1 = abs(x)/sqrt(n);
 tmp = (repmat(x,1,q).*r);
 btmp = V\tmp;
 tmp = tmp-V*btmp;
 W_eta_2 = repmat(sgn_x,1,q).*tmp;
 W_eta = [W_eta_1 W_eta_2];
 % cbar_eta = getcbar_eta(rhobar,distmat,x);
 % cmax = getcbar_eta(0.00001,distmat,x);
 cbar_eta = getcbar(rhobar,distmat);
 cmax_eta = getcbar(0.00001,distmat);
 omega_mat_eta = form_omega_mat(cbar_eta,cmax,q,W_eta,distmat);
 [cv_eta,p_eta]=findcv(omega_mat_eta,alpha,q);
end

