function [cbar,rho] = getcbar_xx(rhobar,distmat,x)
% get cbar for errors, conditional on x
% choose cbar that is as close to rhobar as possible using a grid of values
% for c
XX = x*x';
nc = 100;
cvec = exp(linspace(log(1),log(200),nc)');
rhovec = NaN(nc,1);
for i = 1:nc;
    rhovec(i) = mean(lvech(XX.*exp(-cvec(i)*distmat)));
end;
[~,ii]=min(abs(rhovec-rhobar));
cbar = cvec(ii);
rho = rhovec(ii);

end

