set more off
set linesize 240
clear all
*************************************************************
* Random Walk Example
*************************************************************
import excel "Time_Series_RW.xlsx", sheet("Sheet1") firstrow
log using TS_Fig_1and5_a.log, replace
***********************************
tsset t
*********************************
**** Check Data ****************
********************************
summarize
*********************************
****** Transformations *******
*********************************
generate d_x = D.x
generate d_y = D.y
summarize
*********************************
******* Plot Data -- Levels ***********
*****************************
tsline x, saving(rw_x,replace)
graph export rw_x.png, replace
tsline y, saving(rw_y,replace)
graph export rw_y.png, replace
scatter x y, || lfit x y, saving(rw_x_y_scatter,replace) 
graph export rw_x_y_scatter.png, replace
*********************************
******* Some Regressions ***********
*****************************
regress y x
newey y x, lag(5)

*********************************
******* Plot Data -- Differences ***********
*****************************
tsline d_x, saving(rw_dx,replace)
graph export rw_dx.pdf, replace
tsline d_y, saving(rw_dy,replace)
graph export rw_yd.pdf, replace
scatter d_x d_y, || lfit d_x d_y, saving(rw_dx_dy_scatter,replace) 
graph export rw_dx_dy_scatter.pdf, replace
*********************************
******* Some Regressions ***********
*****************************
regress d_y d_x
newey d_y d_x, lag(5)
log close
