set more off
set linesize 240
clear all
*************************************************************
* CS Levy Brownian Motion Example
*************************************************************
import excel "d_Levy_CZ.xlsx", sheet("Sheet1") firstrow
log using d_Levy_Figure_5.log, replace
***********************************
desc
gen cz = CZ
global root "/Users/mwatson/Documents/git_repos/maptile_geo_templates/build"
global out "$root/geo_templates/cz1990"

egen xe = std(d_x)
egen ye = std(d_y)
maptile xe, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export d_Levy_x_Figure_5.png, replace

maptile ye, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export d_Levy_y_Figure_5.png, replace
 
reg y x
reg y x,r
reg y x, cluster(state_id)

*scatter x y, || lfit x y, saving(conus_lbm_x_y_scatter,replace) 
*graph export conus_lbm_x_y_scatter.png, replace

log close
