% SVP_example.m

% This is main driver program for SVp .. as you will see the program
% (a) Reads in the dataset
% (b) Runs the SVP analysis 

% Two sample datasets are provided
% The first is small, and has n = 200 with data generated in the progam: SVP_Generate_Dataset1.m
%           From that dataset you can see how the data were generated at the actual values of beta_l

% The second dataset is large, and has n = 21,194. It includes the GLS-Transformed HIC and PCE data used as the example in the SVP paper.

%s
clear all;                
this_date = datestr(now,'yyyymmdd');
% Set the seed for the random number generator
rng(81481);


% -- File Directories   
outdir = 'out/';
matdir = 'mat/';
addpath('matlab_functions');

% -- Load Data ---
% Example 1: Load data that was generated by SVP_Generate_Dataset1.
T = readtable('SVP_Dataset_1.csv');
s = [T.s_1 T.s_2];  % Locations
y = T.y;            % y variable
x = T.x;            % regressor with potentially spatially varying coefficient
z = [T.z_1 T.z_2];  % Other regressors -- coefficients are assumed to be constant over space
latlonflag = 0;     % 0 if s is in Euclidean coordinates, 1 if s is in lat/lon

% Example 2: 
% T = readtable('SVP_Dataset_2.csv');
% s = [T.latitude T.longitude];  % Locations
% y = T.HIC;                     % y variable
% x = T.PCE;                     % regressor with potentially spatially varying coefficient
% z = [T.Z];                     % Other regressors -- coefficients are assumed to be constant over space
% latlonflag = 1;                % 0 if s is in Euclidean coordinates, 1 if s is in lat/lon

[deltahat,xi_s,p_value,cv_01,cv_05,cv_10,qstar] = svp_test(y,x,z,s,latlonflag);

% Print Results
disp(' ');
disp('Results from SVP analysis:');
disp(' ');
disp(['Date: ' this_date]);
disp(['n = ' num2str(size(y,1))]);
disp(['Number of regressors with spatially varying coefficients = ' num2str(size(x,2))]);
disp(['Number of regressors with constant coefficients = ' num2str(size(z,2))]);
disp(' ');
disp('Estimated values of delta:');
disp(deltahat);
disp(' ');
disp(['qstar = ' num2str(qstar)]);
disp(' ');
disp('Critical values for SVP test:');
disp(' ');
disp('Significance level     Critical Value');
disp('-------------------------------------');
disp(['0.01                  ' num2str(cv_01)]);
disp(['0.05                  ' num2str(cv_05)]);
disp(['0.10                  ' num2str(cv_10)]);
disp(' ');
disp('SVP test results:');
disp(['xi_s value: ' num2str(xi_s)]);
disp(['p-value = ' num2str(p_value)]);
