% SVP_Generate_Dataset1.m
% Generate an SVP data set for use in SVP program
clear all;                
this_date = datestr(now,'yyyymmdd');
% Set the seed for the random number generator
rng(987654);

% -- File Directories   
outdir = 'out/';
matdir = 'mat/';
addpath('matlab_functions');

% Parameters 
n = 200; % number of data points

% Locations are uniformly distributed on the unit square
s = rand(n,2);

% Generate u
u = randn(n,1);

% Generate x
x = randn(n,1);

% Generate z
z = randn(n,1);
z = [ones(n,1) z];

% Compute Distance matrix
latlonflag = 0;
D = getdistmat_normalized(s,latlonflag);

% Compute the covariance matrix for demeaned Levy-Brownian motion
sigma_lbm_dm = get_sigma_lbm_dm(D);

% Form the matrix square root of the covariance matrix
s_sqrt = sqrt_psd(sigma_lbm_dm);

% Generate beta
kappa = 0.5;
b_level = 1;
b = b_level + kappa*s_sqrt*randn(n,1);

% Generate y
y = x.*b + u;

% Save the data to a csv file
% Construct a Table with the 
% T = table(s,y,x,z,b,u);
T = table(s,y,x,z);
filename = 'SVP_Dataset_1.csv';
writetable(T,filename);




