function [V,lambda]=eig_q(S,q);
    % Compute the q largest eigenvalues and eigenvectors of S
    % Eigenvalues are stored in the diagonal of lamda ordered from largest to smallest
    % Eigenvectors are stored in the columns of V corresponding to the eigenvalues in lamda

    [V,Lam] = eigs(S,q);
    lam = diag(Lam);
    [lambda,ii] = sort(lam,'descend');
    V = V(:,ii);
    
end