function [kappa]=find_kappa_50(lam,cv,kappa_max)
% Find critical value given q
%   
small = 0.0005;

kap0 = 0;   % This yields rejection frequency of alpha < 0.5
% If Possible find a kappa with rejection frequency >= 0.5;
kap1 = kappa_max;
evals = lam + (kap1*lam).^2 -cv*(1+(kap1^2)*lam);
evals = evals/evals(1);
p = imhof_evals(evals);
if p < 0.5
    kappa = kappa_max;
    return;
end

% Here ..  kap0 is too small and kap1 is too large -- use bisection to find kappa for 50% rejection probability
p = 1;
irep = 0;
while abs(p-0.50) > small
    irep = irep + 1;
    kapm = (kap0+kap1)/2;
    evals = lam + (kapm*lam).^2 -cv*(1+(kapm^2)*lam);
    evals = evals/evals(1);
    p = imhof_evals(evals);
    if p < 0.5
        kap0 = kapm;  % Increase kap0
    else
        kap1 = kapm;  % Decrease kap1
    end
    if irep > 1000
        disp('Warning: In find_kappa_50 ...  Bisection did not converge');
        break;
    end
end

kappa = kapm;  % This is the kappa that yields rejection frequency of 0.5
  
end

