function [cv,p]=findcv(omega_mat,lam,alpha)
% Find critical value given q
%   
small = 0.0005;

% Construct Cholesky factorization of omega_mat
omega_mat_chol = NaN(size(omega_mat));
for i = 1:size(omega_mat,3)
  omega_mat_chol(:,:,i) = chol(squeeze(omega_mat(:,:,i)));
end 

% Get critical value of a given value of c .. begin with c0
icheck = 1;
itest = 0;

while itest == 0
  omega_chol = squeeze(omega_mat_chol(:,:,icheck));
  % Find cv0 with rejection frequency >= alpha
  cv0 = lam(1)/2;  % Initial guess for cv0, which is the sum of the eigenvalues
  icv0 = 0;
  while icv0 == 0
    p = rejprob(cv0,omega_chol,lam);
    if p >= alpha
      icv0 = 1;
    else
      cv0 = cv0/2;
    end
  end

  % Find cv1 with rejection frequency < alpha
  cv1 = cv0+lam(1)/2;
  icv1 = 0;
  while icv1 == 0
     p = rejprob(cv1,omega_chol,lam);
     if p < alpha
        icv1 = 1;
     else
         cv1 = cv1 + lam(1)/2;
     end
  end

  % Now cv0 is too small and cv1 is too large -- use bisection to find cv
  % Bisection determination of cv
  cvm = (cv0+cv1)/2;
  p = rejprob(cvm,omega_chol,lam);
  irep = 0;
  while abs(p-alpha) > small
      cvm = (cv0+cv1)/2;
      p = rejprob(cvm,omega_chol,lam);
      if p > alpha
        cv0 = cvm;
      else
        cv1 = cvm;
      end
      irep = irep + 1;
      if irep > 100
        warning('p may not be accurate in cv');
        disp(['cv0 = ' num2str(cv0) ', p = ' num2str(p) ', alpha = ' num2str(alpha)]);
        break;
      end
  end 

  % Find maximum rejection probability
  [p,ii]= maxrejprob(cvm,omega_mat_chol,lam);
  
  if ii == icheck
      itest = 1;
  else
      icheck = ii;
  end
    
end  
  
cv = cvm;
 

end

