function [omega_mat] = form_omega_matrices(cbar_min,cbar_max,R,distmat)

q = size(R,2);
% Step 1: Compute Omega Matrices for grid of values of c >= cbar_min
nc = ceil(log(cbar_max/cbar_min)/log(1.2));
nc = max([2;nc]);
c_grid = cbar_min*(1.2.^(0:1:nc)');
omega_mat = NaN(q,q,nc);
for i = 1:nc
    omega_mat(:,:,i) = R'*(exp(-c_grid(i)*distmat))*R;
end

end
