function [qstar] = get_qstar(omega_mat,lambda,q_min,q_max,alpha)

    % Compute critical value for each q
    cv_q_vec = NaN(q_max,1);
    p_q_vec = NaN(q_max,1);
    for q = q_min:q_max
        [cv,p] = findcv(omega_mat(1:q,1:q,:),lambda(1:q),alpha);
        cv_q_vec(q) = cv;
        p_q_vec(q) = p;
    end

    % Compute the Value of kappa_50 for each q
    kappa_max = 1e5;  % Largest value of kappa (note, this a very large value using the lambda(1) = 1/pi^2 normalization)
    kappa_50_vec = kappa_max*ones(q_max,1);
    for q = q_min:q_max
        lam = lambda(1:q);
        cv = cv_q_vec(q);
        kappa = find_kappa_50(lam,cv,kappa_max);
        kappa_50_vec(q) = kappa;
    end
    [kappa_min,qstar] = min(kappa_50_vec);
    if kappa_min == kappa_max
        disp('No valid kappa found, setting qstar = q_max');
        qstar = q_max;
    end
    
end