function [p] = imhof_p(evals)
% Compute the probability that Z'AZ > 0 using Imhof's method.
% Approximation using Gaussian quadrature.
global GQxw;
 
    if max(evals) <= 0
        % If all eigenvalues are non-positive, the probability is 0.
        p = 0;
        return;
    end
    if min(evals) >= 0
        % If all eigenvalues are non-negative, the probability is 1.
        p = 1;
        return;
    end

    t = GQxw(:,1);
    w = GQxw(:,2);

    num = sin(0.5*sum(atan(t*evals'),2));
    den = sqrt(sqrt(1 + (t*evals').^2));
    den = t.*prod(den,2);
    v = num./den;
    val = v'*w;
    p = 0.5 + val/pi;

end