function [p] = imhof_p(A)
% Compute the probability that Z'AZ > 0 using Imhof's method.
% Approximation using Gaussian quadrature.

    evals = eig(A);
    evals = evals/max(abs(evals)); % Scale eigenvalues to avoid numerical issues

    p = imhof_evals(evals);

end