function [deltahat,xi_s,p_value,cv_01,cv_05,cv_10,qstar] = svp_test(y,x,z,s,latlonflag);

    % --- Variables, etc. for Gaussian quadrature weights used for Imhof's approximation
    global GQxw;  % Global variable for Gaussian quadrature points and weights
    im_lower = 0.0;
    im_upper = 100.0;
    n_im = 500;  % Number of points in the integration
    [xgq,wgq] = lgwt(n_im,im_lower,im_upper);
    GQxw = [xgq wgq];   % first column are the evaluation points, second column are the weights

    % --- Parameters that are suggested in the text
    % Minimun and maximum values of q
    q_min = 2;
    q_max = 50;

    % Value of rho_bar ... size is control for persistence less that are equal to this values
    rhobar_max = 0.01;     % Maximum average correlation for the test
    rhobar_min = 0.00001;  % Smallest value of rho ... This is an approximation to rhobar = 0

    % Size of test used to compute the 50% power values to determine qstar
    alpha = 0.05;

    % Paramaters associated with the dataset.
    n = size(y,1);  % number of observations

    % Compute some constants that are used in the analysis

    % Compute D, the distance matrix
    % disp('Computing distance matrix ...');
    % tic
    D = getdistmat_normalized(s,latlonflag);
    % toc

    % Compute demeaned LBM covariance matrix  
    % disp('Computing covariance matrix ...');
    % tic
    sigma_lbm_dm = get_sigma_lbm_dm(D);
    % toc

    % Compute the q_max largeste eigenvalues and eigenvectors of sigma_lbm_dm
    % disp('Computing eigenvalues and eigenvectors ...');
    % tic
    [R,lambda] = eig_q(sigma_lbm_dm,q_max);  % Note that R has unit length eigenvectors
    norm = (1/(pi^2))*(1/lambda(1));         % A convenient normalization -- set largest eigenvalue to 1/pi^2 -- the value from time series. (This makes it easier to interpret the kappa values).
    lambda = norm*lambda;
    R = sqrt(norm)*R;
    % toc

    % Compute the minimum and maximum values of cbar ... test constrols size uniformly over this range.
    % disp('Computing Omega and cbar range ...');
    % tic
    cbar_min = getcbar(rhobar_max,D);
    cbar_max = getcbar(rhobar_min,D);
    % Let V = R*eta, where eta ~ G_c. Let Omega denote the variance of V. Compute Omega for a grid of values of range of value of cbar
    omega_mat = form_omega_matrices(cbar_min,cbar_max,R,D);
    % toc

    % Compute qstar, the 50% power maximizing value of q for tests with size alpha
    % display('Computing qstar ...');
    % tic
    qstar = get_qstar(omega_mat,lambda,q_min,q_max,alpha);
    % Save key variables for this value of q
    R = R(:,1:qstar);
    lambda = lambda(1:qstar);
    omega_mat = omega_mat(1:qstar,1:qstar,:);
    % toc

    % Compute 1%, 5% and 10% critical values using this value of q
    cv_01 = findcv(omega_mat,lambda,0.01);
    cv_05 = findcv(omega_mat,lambda,0.05);
    cv_10 = findcv(omega_mat,lambda,0.10);

    % Run Regression and compute the test statistic
    w = x;
    if size(z,1) > 1
        w = [x z];
    end
    deltahat = w\y;
    ehat = y - w*deltahat;
    xehat = x.*ehat;
    Y = (R'*xehat);
    Y2 = Y.^2;
    xi_s = sum(Y2.*lambda)/sum(Y2);
    % Compute the p-value of xsi_s
    p_value = get_pvalue(xi_s,omega_mat,lambda);

end