% Plot Results for Light MC .. Plot Distribution of average length
% (conditional on x)

% -- File Directories   
figdir = 'fig/';

% Plot UMs Results
% Read Results u = a model
al_10 = NaN(14,6);
al_03 = NaN(14,6);
al_01 = NaN(14,6);
al_001 = NaN(14,6);

b1 = 4;
for i = 1:14
    b2 = b1 + 5;
    
    rng_str = ['B' num2str(b1) ':B' num2str(b2)];
    tmp = readmatrix('Length_table.xlsx','Range',rng_str);
    al_10(i,:) = tmp';
    
    rng_str = ['D' num2str(b1) ':D' num2str(b2)];
    tmp = readmatrix('Length_table.xlsx','Range',rng_str);
    al_03(i,:) = tmp';
    
    rng_str = ['F' num2str(b1) ':F' num2str(b2)];
    tmp = readmatrix('Length_table.xlsx','Range',rng_str);
    al_01(i,:) = tmp';
    
    rng_str = ['H' num2str(b1) ':H' num2str(b2)];
    tmp = readmatrix('Length_table.xlsx','Range',rng_str);
    al_001(i,:) = tmp';
   
    
    b1 = b1+10;
end

%% 

trend = (1:1:14)';
eps = 0.1;
t1 = trend-1.5*eps;
t2 = trend-0.5*eps;
t3 = trend+0.5*eps;
t4 = trend+1.5*eps;

lw = 4;
ms = 10;
leg_fs = 20;
ax_fs = 20;
tit_fs = 25;

fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
tmp1 = linspace(0,20,100)';
tmp2 = ones(100,1);

errorbar(t1,al_10(:,6),al_10(:,6)-al_10(:,1),al_10(:,6)-al_10(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Black','MarkerFaceColor','Black','LineWidth',lw,'Color','Black');
hold on;
 errorbar(t2,al_03(:,6),al_03(:,6)-al_03(:,1),al_03(:,6)-al_03(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Blue','MarkerFaceColor','Blue','LineWidth',lw,'Color','Blue');
 errorbar(t3,al_01(:,6),al_01(:,6)-al_01(:,1),al_01(:,6)-al_01(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Red','MarkerFaceColor','Red','LineWidth',lw,'Color','Red');
 errorbar(t4,al_001(:,6),al_001(:,6)-al_001(:,1),al_001(:,6)-al_001(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Green','MarkerFaceColor','Green','LineWidth',lw,'Color','Green');
plot(tmp1,tmp2,': k','LineWidth',3);
hold off;
ylim([0.6 2]);
xlim([0,14.5]);
xlabel('Experiment','FontSize',ax_fs);
ylabel('Rejection Frequency','FontSize',ax_fs);
xticks((1:1:16));
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',ax_fs);
%title('(a) 48-states experiments');
legend('$$\overline{\rho}_{max} = 0.10$$','$$\overline{\rho}_{max} = 0.03$$','$$\overline{\rho}_{max} = 0.01$$','$$\overline{\rho}_{max} = 0.001$$','Interpreter','latex','Location','Southwest','FontSize',leg_fs);
figure_to_png(figdir, 'Figure_Light_Length_1');
close(fig);


