% Plot Results for Light MC .. Figure 2 in paper
% Note .. this must be updated to Plot Mean

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
matdir = 'mat/';


% Plot UMs Results
% Read Results u = a model
mat_np_a = NaN(14,6);
mat_np_e = NaN(14,6);
mat_p_a = NaN(14,6);
mat_p_e = NaN(14,6);

b1 = 7;
for i = 1:14;
    b2 = b1 + 5;
    
    rng_str = ['F' num2str(b1) ':F' num2str(b2)];
    tmp = readmatrix('FinalRun120821.xlsx','Range',rng_str);
    ii = tmp < 0;
    tmp(ii) = NaN;
    mat_np_a(i,:) = tmp(:,1)';
    rng_str = ['L' num2str(b1) ':L' num2str(b2)];
    tmp = readmatrix('FinalRun120821.xlsx','Range',rng_str);
    ii = tmp < 0;
    tmp(ii) = NaN;
    mat_np_e(i,:) = tmp(:,1)';
    
    b1 = b1+8;
end;

b1 = 127;
for i = 2:14;
    b2 = b1 + 5;
    
    rng_str = ['F' num2str(b1) ':F' num2str(b2)];
    tmp = readmatrix('FinalRun120821.xlsx','Range',rng_str);
    ii = tmp < 0;
    tmp(ii) = NaN;
    mat_p_a(i,:) = tmp(:,1)';
    rng_str = ['L' num2str(b1) ':L' num2str(b2)];
    tmp = readmatrix('FinalRun120821.xlsx','Range',rng_str);
    ii = tmp < 0;
    tmp(ii) = NaN;
    mat_p_e(i,:) = tmp(:,1)';
    
    b1 = b1+8;
end;

trend = (1:1:14)';
eps = 0.1;
t1 = trend-1.5*eps;
t2 = trend-0.5*eps;
t3 = trend+0.5*eps;
t4 = trend+1.5*eps;

lw = 4;
ms = 10;
leg_fs = 20;
ax_fs = 20;
tit_fs = 25;

fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
tmp1 = linspace(0,20,100)';
tmp2 = 0.05*ones(100,1);

errorbar(t1,mat_np_a(:,6),mat_np_a(:,6)-mat_np_a(:,1),mat_np_a(:,6)-mat_np_a(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Black','MarkerFaceColor','Black','LineWidth',lw,'Color','Black');
hold on;
 errorbar(t2,mat_np_e(:,6),mat_np_e(:,6)-mat_np_e(:,1),mat_np_e(:,6)-mat_np_e(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Blue','MarkerFaceColor','Blue','LineWidth',lw,'Color','Blue');
 errorbar(t3,mat_p_a(:,6),mat_p_a(:,6)-mat_p_a(:,1),mat_p_a(:,6)-mat_np_a(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Red','MarkerFaceColor','Red','LineWidth',lw,'Color','Red');
 errorbar(t4,mat_p_e(:,6),mat_p_e(:,6)-mat_p_e(:,1),mat_p_e(:,6)-mat_np_e(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Green','MarkerFaceColor','Green','LineWidth',lw,'Color','Green');
plot(tmp1,tmp2,': k','LineWidth',3);
hold off;
ylim([0 0.15]);
xlim([0,14.5]);
xlabel('Experiment','FontSize',ax_fs);
ylabel('Rejection Frequency','FontSize',ax_fs);
xticks((1:1:16));
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',ax_fs);
title('(a) 48-states experiments');
legend('Non-panel, e ~ f_{Matern}','Non-panel, e ~ sign(x) \times f_{Matern}','Panel, e ~ f_{Matern}','Panel, e ~ x^{s} \times f_{Matern}','Location','Northwest','FontSize',leg_fs);
figure_to_png(figdir, 'Figure_Light_Matern');
close(fig);


