% Plot Results for Light MC .. Figure 3 in paper -- Panel case
% Note .. this must be updated to Plot Mean

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
matdir = 'mat/';

% Plot UMs Results
% Read Results u = a model
scpc_a = NaN(14,6);
cscpc_a = NaN(14,6);
hr_a = NaN(14,6);
conley_a = NaN(14,6);

scpc_e = NaN(14,6);
cscpc_e = NaN(14,6);
hr_e = NaN(14,6);
conley_e = NaN(14,6);

b1 = 127;
for i = 2:14;
    b2 = b1 + 5;
    
    rng_str = ['B' num2str(b1) ':E' num2str(b2)];
    tmp = readmatrix('FinalRun120821.xlsx','Range',rng_str);
    ii = tmp < 0;
    tmp(ii) = NaN;
    scpc_a(i,:) = tmp(:,1)';
    cscpc_a(i,:) = tmp(:,2)';
    conley_a(i,:) = tmp(:,3)';
    hr_a(i,:) = tmp(:,4)';
    
    rng_str = ['H' num2str(b1) ':K' num2str(b2)];
    tmp = readmatrix('FinalRun120821.xlsx','Range',rng_str);
    ii = tmp < 0;
    tmp(ii) = NaN;
    scpc_e(i,:) = tmp(:,1)';
    cscpc_e(i,:) = tmp(:,2)';
    conley_e(i,:) = tmp(:,3)';
    hr_e(i,:) = tmp(:,4)';
    
    b1 = b1+8;
end;

trend = (1:1:14)';
eps = 0.1;
t1 = trend-eps;
t2 = trend;
t3 = trend+eps;

lw = 4;
ms = 10;
leg_fs = 20;
ax_fs = 20;
tit_fs = 25;

fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
tmp1 = linspace(0,20,100)';
tmp2 = 0.05*ones(100,1);

errorbar(t1,scpc_a(:,6),scpc_a(:,6)-scpc_a(:,1),scpc_a(:,6)-scpc_a(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Black','MarkerFaceColor','Black','LineWidth',lw,'Color','Black');
hold on;
 errorbar(t2,cscpc_a(:,6),cscpc_a(:,6)-cscpc_a(:,1),cscpc_a(:,6)-cscpc_a(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Blue','MarkerFaceColor','Blue','LineWidth',lw,'Color','Blue');
 d2 = errorbar(t3,conley_a(:,6),conley_a(:,6)-conley_a(:,1),conley_a(:,6)-scpc_a(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Red','MarkerFaceColor','Red','LineWidth',lw,'Color','Red');
 d2.Bar.LineStyle = 'dotted';
plot(tmp1,tmp2,': k','LineWidth',3);
hold off;
ylim([0 0.9]);
xlim([0,14.5]);
xlabel('Experiment','FontSize',ax_fs);
ylabel('Rejection Frequency','FontSize',ax_fs);
xticks((1:1:16));
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',ax_fs);
title('(a) $e \sim \mathcal{G}_{exp}(c)$','Interpreter','latex','FontSize',tit_fs);
legend('SCPC','C-SCPC','KERNEL (dots)','Location','Northwest','FontSize',leg_fs);
figure_to_png(figdir, 'Figure_Light_2_a');
close(fig);

fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
errorbar(t1,scpc_e(:,6),scpc_e(:,6)-scpc_e(:,1),scpc_e(:,6)-scpc_e(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Black','MarkerFaceColor','Black','LineWidth',lw,'Color','Black');
hold on;
 errorbar(t2,cscpc_e(:,6),cscpc_e(:,6)-cscpc_e(:,1),cscpc_e(:,6)-cscpc_e(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Blue','MarkerFaceColor','Blue','LineWidth',lw,'Color','Blue');
 d2 = errorbar(t3,conley_e(:,6),conley_e(:,6)-conley_e(:,1),conley_e(:,6)-scpc_e(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Red','MarkerFaceColor','Red','LineWidth',lw,'Color','Red');
 d2.Bar.LineStyle = 'dotted';
 plot(tmp1,tmp2,': k','LineWidth',3);
hold off;
ylim([0 0.9]);
xlim([0,14.5]);
xlabel('Experiment','FontSize',ax_fs);
ylabel('Rejection Frequency','FontSize',ax_fs);
xticks((1:1:16));
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',ax_fs);
title('(b) $e \sim x^{s} \times \mathcal{G}_{exp}(c)$','Interpreter','latex','FontSize',tit_fs);
figure_to_png(figdir, 'Figure_Light_2_b');
close(fig);
