% Plot Results for Light MC .. Figure 2 in paper
% Note .. this must be updated to Plot Mean

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
matdir = 'mat/';

% Plot UMs Results
% Read Results u = a model
mat_a = NaN(6,6);
mat_e = NaN(6,6);

b1 = 2;
for i = 1:6;
    b2 = b1 + 5;
    rng_str = ['F' num2str(b1) ':F' num2str(b2)];
    tmp = readmatrix('MCWBRun121721.xlsx','Range',rng_str);
    ii = tmp < 0;
    tmp(ii) = NaN;
    mat_a(i,:) = tmp(:,1)';
    
    rng_str = ['L' num2str(b1) ':L' num2str(b2)];
    tmp = readmatrix('MCWBRun121721.xlsx','Range',rng_str);
    ii = tmp < 0;
    tmp(ii) = NaN;
    mat_e(i,:) = tmp(:,1)';
    b1 = b1+8;
end;

trend = (1:1:6)';
eps = 0.1;
t1 = trend-0.5*eps;
t2 = trend+0.5*eps;

lw = 4;
ms = 10;
leg_fs = 20;
ax_fs = 20;
tit_fs = 25;

fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
tmp1 = linspace(0,20,100)';
tmp2 = 0.05*ones(100,1);

errorbar(t1,mat_a(:,6),mat_a(:,6)-mat_a(:,1),mat_a(:,6)-mat_a(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Black','MarkerFaceColor','Black','LineWidth',lw,'Color','Black');
hold on;
 errorbar(t2,mat_e(:,6),mat_e(:,6)-mat_e(:,1),mat_e(:,6)-mat_e(:,5),'s','MarkerSize',ms,'MarkerEdgeColor','Blue','MarkerFaceColor','Blue','LineWidth',lw,'Color','Blue');
plot(tmp1,tmp2,': k','LineWidth',3);
hold off;
ylim([0 0.15]);
xlim([0,6.5]);
xlabel('Experiment','FontSize',ax_fs);
ylabel('Rejection Frequency','FontSize',ax_fs);
xticks((1:1:16));
a = get(gca,'XTickLabel');
set(gca,'XTickLabel',a,'fontsize',ax_fs);
title('(b) WDI experiments');
legend('e ~ f_{Matern}','e ~ x^{s} \times f_{Matern}','Location','Northwest','FontSize',leg_fs);
figure_to_png(figdir, 'Figure_WDI_Matern');
close(fig);


