module dependence
	use basicmodule
	implicit none
	
	integer, parameter	:: nW=250
	
	contains
	
	subroutine depcorr(xsi,s)
		use rlse_int
		integer, parameter	:: nsim=5000
		real	:: xsi,s,dta(k,2,nsim),outtab(k)
		real, allocatable	:: ys0(:,:)
		integer	:: l,j,n0
		n0=n
		n=2
		if(allocated(ys0)) deallocate(ys0)
		allocate(ys0(k,n))
!$omp parallel do		
		do l=1,nsim
			ys=ys0
			call draw_dependence([0.0,1.0,xsi],s) 
			dta(:,:,l)=exp(-log(1+xsi*ys)/xsi)
		enddo
		do j=1,k
			outtab(j)=getcorr(dta(j,1,:),dta(j,2,:))
		enddo
		print *,"correlation"
		call mdisp(outtab)
		n=n0
		if(allocated(ys)) deallocate(ys)
		allocate(ys(k,n))

	end subroutine	
	
	subroutine draw_dependence(msx,s)
		real	:: msx(3),s
		integer, parameter	:: km=5
		real	:: paths(n,k*km),y(k),r,xsi
		integer	:: j
		xsi=msx(3)
		do j=1,k*km
			paths(:,j)=refBM(xsi,s)
		enddo
		do j=1,n
			paths(j,:)=-sort(-paths(j,:))
			r=real(k*km)**xsi
			y=(exp(paths(j,1:k))-r)/(xsi*r)
			y=y*msx(2)+msx(1)
			ys(:,j)=y
		enddo
	end subroutine
	
	
	
	function refBM(xsi,s) result(val)
		real	:: xsi,s,val(n)
		real	:: mu,y(0:(n-1)*nW)
		integer	:: t
		mu=-.5*(1/xsi)*s**2/nW
		call rnun(y(0:0))
		y(0)=-log(y(0))*xsi
		call rnnoa(y(1:))
		do t=1,(n-1)*nW
			y(t)=abs(y(t-1)+mu+y(t)*s/sqrt(real(nW)))
		enddo
		val=y([((t-1)*nw,t=1,n)])
	end function
		
		
	
	
end module