% Read in the Events Data and plot

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;
global datadir;

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
datadir = '../data/';

% Read in Data
str_data = [ matdir 'CitySize_100.mat'];
load(str_data)

% Plot Time Series plot of data use log scale
k1 = 30;
ax_fs = 25;
m_size = 12;
figure('Units', 'normalized', 'Position', [0 0 0.6 0.5]); % For Dell Wide Monitor
subplot(1,2,1)
plot(yr,log(cs_data(:,1:k1)),'o','MarkerFaceColor','blue','MarkerEdgeColor','black','MarkerSize',m_size);
xlim([1890 2030])
% Add x labels at 1900, 1940, 1980, 2020
xticks([1900 1940 1980 2020]);
xlabel('Year')
ylabel('ln(Percentage Points)')
title('A. City Size')
ax = gca;
ax.FontSize = ax_fs;

% Read in Data
str_data = [matdir 'FirmSize_top100_byYear.mat'];
load(str_data)
emp_all = emp_largest_normalized;

% Select years
yr = calvec;
yr_use = [1950 1973 1996 2019]';
yr = calvec;
emp_data = NaN(length(yr_use),size(emp_all,2));
for i = 1:length(yr_use)
    yr_idx = find(yr==yr_use(i));
    emp_data(i,:) = emp_all(yr_idx,:);
end

% Plot Time Series plot of data use log scale
subplot(1,2,2)
plot(yr_use,log(emp_data(:,1:k1)),'o','MarkerFaceColor','blue','MarkerEdgeColor','black','MarkerSize',m_size);

xlim([1945 2025])
% Add x labels at 1900, 1940, 1980, 2020
xticks(yr_use);
xlabel('Year')
ax = gca;
ax.FontSize = ax_fs;
title('B. Firm Size')

% Save the figure as a PNG file
saveas(gcf, [figdir 'CitySize_FirmSize_Plot.png']);
%close(gcf);



