% Construct GARCH Filtered Standardized Daily Returns
% Save Daily Returns and Standardized Returns

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;
global datadir;

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
datadir = '../data/';

% Read in Data
data_fname = [matdir 'Returns_Large.mat'];
load(data_fname);
ret_large = ret;
data_fname = [matdir 'Returns_Small.mat'];
load(data_fname);
ret_small = -ret;

% Plot extremes of returns
ax_fs = 25;
m_size = 12;
figure('Units', 'normalized', 'Position', [0 0 0.6 0.5]); % For Dell Wide Monitor
subplot(1,2,1)
 plot(calvec,ret_large,'o','MarkerFaceColor','blue','MarkerEdgeColor','black','MarkerSize',m_size);
 xlim([1920,2030])
 ylim([0 12])
 xlabel('Year')
 ylabel('Standard Deviation')
 title('A. Largest Returns')
 ax = gca;
 ax.FontSize = ax_fs;
 subplot(1,2,2)
 plot(calvec,ret_small,'o','MarkerFaceColor','blue','MarkerEdgeColor','black','MarkerSize',m_size);
 xlim([1920,2030])
 ylim([-12 0])
 xlabel('Year')
 % ylabel('Standard Deviation')
 title('B. Smallest Returns')
 ax = gca;
 ax.FontSize = ax_fs;


saveas(gcf, [figdir 'Returns_extremes.png']);
close(gcf);
