% Construct GARCH Filtered Standardized Daily Returns
% Save Daily Returns and Standardized Returns

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;
global datadir;

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';

% Read in Data
fname = [matdir 'SP500_VW_Daily_StandardizedReturns_1926_2022.mat'];
load(fname);

% Save Extremes: Biannual Extremes
fname = [matdir 'SP500_StandardizedReturns_Extremes_Biannual_1926_2022.mat'];
load(fname);

ax_fs = 35;
m_size = 10;
% Plot Raw Returns and Standardized Returns
figure('Units', 'normalized', 'Position', [0 0 0.5 0.75]); % For Dell Wide Monitor

ax_fs = 35;
subplot(2,2,1)
 plot(cal,ret);
 xlim([1920,2030]);
%  xlabel('Year');
 ax = gca;
 ax.FontSize = ax_fs;
 title('A. Daily returns');
subplot(2,2,2)
 plot(cal,ret_std);
 xlim([1920,2030]);
 ylim([-12 10]);
%  xlabel('Year');
ylabel('Standard deviation');
 ax = gca;
 ax.FontSize = ax_fs;
 title('B. GARCH(1,1)-standardized returns');
subplot(2,2,3)
 plot(calvec,ret_std_l,'o','MarkerFaceColor','blue','MarkerEdgeColor','black','MarkerSize',m_size);
 xlim([1920,2030])
 ylim([0 10])
 ylabel('Standard deviation');
 xlabel('Year')
 title('C. Largest daily std. return')
 ax = gca;
 ax.FontSize = ax_fs;
subplot(2,2,4)
 plot(calvec,ret_std_s,'o','MarkerFaceColor','blue','MarkerEdgeColor','black','MarkerSize',m_size);
 xlim([1920,2030])
 ylim([-12 0])
 xlabel('Year')
 title('D. Smallest daily std. return')
 ax = gca;
 ax.FontSize = ax_fs;

saveas(gcf, [figdir 'Returns_Appendix.png']);
close(gcf);
