% Write JSON Files for STAN

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;
global datadir;

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
standir = '../Stan/Returns/';

%%%%%%
fy = 1926; 
ly = 2022;

%%%% Model string
mod_str = ['SP500_Returns_Std_' num2str(fy) '_' num2str(ly) '_'];

%%%%%%% Load Data
data_file = 'SP500_StandardizedReturns_Extremes_Biannual_1926_2022.mat';
load([matdir data_file]);

% Set up Sample Period
ismpl = smpl(calvec,[fy 1],[ly 2],2);
calvec = calvec(ismpl==1);
ret_std_l = ret_std_l(ismpl==1);
ret_std_s = ret_std_s(ismpl==1);
T = length(calvec);
k = 1;

% Save Data
str_save = [standir 'Returns_Large.xlsx'];
writematrix(ret_std_l,str_save);
str_save = [standir 'Returns_Small.xlsx'];
writematrix(abs(ret_std_s),str_save);

% Save Matlab files -- same as excel files
ret = ret_std_l;
save([matdir 'Returns_Large'],'ret','calvec');
ret = abs(ret_std_s);
save([matdir 'Returns_Small'],'ret','calvec');
