% Read in the Events Data and plot

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;
global datadir;
% rng(197347);

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
datadir = '../data/';

% Read in Data
% Read in Events data
data_fname = [matdir 'Disasters.mat'];
load(data_fname);
% Rename some variables
D = y';
ii = D == -1;
D(ii==1) = NaN;

ax_fs = 30;
m_size = 18;
figure('Units', 'normalized', 'Position', [0 0 0.5 0.6]); % For Dell Wide Monitor
plot(calvec,log(D),'o','MarkerFaceColor','blue','MarkerEdgeColor','black','MarkerSize',m_size);
xlim([1980 2025]);
% ylim([0 275]);
xlabel('Year');
ylabel('ln($Billions)');
ax = gca;
ax.FontSize = ax_fs;

% Save the figure as a PNG file
saveas(gcf, [figdir 'WeatherDamages.png']);
close(gcf);




