% Read in the Events Data and plot

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;
global datadir;
% rng(197347);

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';


% Read in Data
% Read in Events data
fname=[matdir 'Damage_monthly_excl_drought_fires_1980_2023.mat'];
load(fname);

D = y';
ii = D == -1;
D(ii==1) = NaN;

tau_vec = ones(size(calvec,1),1);

ax_fs = 35;
m_size = 10;
l_width = 3;
figure('Units', 'normalized', 'Position', [0 0 0.5 0.75]); % For Dell Wide Monitor


subplot(2,2,1);
plot(calvec,log(D),'o','MarkerFaceColor','blue','MarkerEdgeColor','black','MarkerSize',m_size);
xlim([1980 2023]);
ylim([0 6]);
xlabel('Year');
ylabel('ln($Billions)');
title('A. Monthly Damages');
ax = gca;
ax.FontSize = ax_fs;


fname=[matdir 'Disasters_norm.mat'];
load(fname);
y = y_norm;
D = y';
ii = D == -1;
D(D == -1) = NaN;


subplot(2,2,2);
plot(calvec,log(D),'o','MarkerFaceColor','blue','MarkerEdgeColor','black','MarkerSize',m_size);
xlim([1980 2023]);
ylim([0 6]);
xlabel('Year');
ylabel('ln($Billions)');
title('B. Monthly Damages (Normalized)');
ax = gca;
ax.FontSize = ax_fs;

subplot(2,2,3);
T = length(calvec);
plot(calvec,ones(T,1),'- b','LineWidth',l_width);
hold on;
plot(calvec,tau_norm,': b','LineWidth',l_width);
hold off;
xlim([1980 2023]);
ylim([0 3]);
xlabel('Year');
ylabel('$Billions');
title('C. Censoring Threshold');
% Insert legend
legend('Not Normalized','Normalized','Location','NorthEast');
ax = gca;
ax.FontSize = ax_fs;

% Save the figure as a PNG file
saveas(gcf, [figdir 'WeatherDamages_Appendix.png']);
close(gcf);



