% Read in the Events Data and plot

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;


% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
datadir = '../Data/WeatherDamages/';
standir = '../Stan/WeatherDamages/';

tau = 1.0;     % Threshold

% Save Key Files for use in Matlab
fname=[matdir 'Damage_monthly_excl_drought_fires_1980_2023.mat'];
load(fname);
y(y==-1.0) = NaN;
calvec_damages = calvec;

% Read in Capital Stock Data
fname = [matdir 'Kstock.mat'];
load(fname);
calvec_Kstock = calvec;

% Make Sure Dates line up
ii = sum(abs(calvec_Kstock-calvec_damages));
if ii > 0.001
    error('calendars do not line up')
end

% Capital Stock series to use:
KStock = KStock_BEA;

% Normalize KStock to equal unity in final period
KStock=KStock/KStock(end);

% Normalize the value of y
y_norm = y./repmat(KStock',size(y,1),1);
tau_norm = tau./KStock;
ii = isnan(y_norm);
y_norm(ii==1) = -1.0;

% Save Data
str_save = [matdir 'Disasters_norm.mat'];
save(str_save,'y_norm','nobs','tau_norm','calvec');

% Save y data
str_save = [standir 'Disasters_y_norm.xlsx'];
writematrix(y_norm,str_save);
str_save = [standir 'Disasters_nobs.xlsx'];
writematrix(nobs,str_save);
str_save = [standir 'Disasters_tau_norm.xlsx'];
writematrix(tau_norm,str_save);

% Save Data in Excel File
% Create Table with calvec, nobs and y data
y_norm=y_norm';
Tab = table(calvec,tau_norm,nobs,y_norm);
filename = [datadir 'Disasters_Normalized_All_Variables.xlsx'];
writetable(Tab,filename);
