function L_Stat = compute_nyblom(score_mat,info)
    % Compute Nyblom L Statistic. 
    % score_mat is a T x k matrix of derivatives of log-likelihood evaluated at MLE
    %
    % Step 1 :  Dimensions, etc.
    d = score_mat;
    T = size(d,1);
    k = size(d,2);
    % Step 2:  Compute Covariance Matrix for Scores
    V = info; % Covariance Matrix for Scores  
    % Standardize Score
    Vinv = inv(V);
    B = chol(Vinv)';  % Vinv = B*B'
    d_std = d*B;     % d_std is standardized scores
    % Form partial sums
    cd_std = cumsum(flipud(d_std));
    Lm_mat = sum(cd_std.^2)/T^2;
    L_Stat = sum(Lm_mat);
end
