function ln_pdf = llf_GEV_t(Y,xi,sigma,mu)
    % Compute the log pdf of the k-largest order statistics using the GEV distribution
    % Y is the data:  This is a kx1 vector (typically the t'th observation)
    % ln_pdf is a scalar
   
    % Step 1: normalize the data
    X = (Y-mu)/sigma;
    % Step 2: Check support
    if sigma < 0
        ln_pdf = -1.0E+10;
        return
    end
    xi_X = xi*X;
    tmp = min(min(xi_X));
    if tmp < -1
        ln_pdf = -1.0E+10;
        return
    end

    % Step 3: Compute log pdf
    ln_1 = -((xi+1)/xi)*log1p(xi_X)-log(sigma);
    ln_2 = -((1+xi_X(end)).^(-1/xi));
    ln_1 = sum(ln_1);
    ln_pdf = ln_1+ln_2;
end