function f = minus_llf_exceedance_gev_con_x_90(x,Y_data,nobs_vec,tau_vec,x_90_con)
    % Minus log-likelihood from exceedance likelihood using GEV parameterization
    %  Here the threshold, tau_vec, is allowed to be time varying
    %  The value of xsi is constrained to be xsi_con 
    small = 1.0E-10;
    big = 1.0E+10;
   
    xi = x(1);
    sigma = x(2);
    p = 0.90;
    tmp = gevinv(p,xi,sigma,-x_90_con);
    mu = -tmp;
    T = size(Y_data,1);
    llf_vec = zeros(T,1);
    % Check support
    if sigma <= 0
        f = big;
        return
    end
    X = (tau_vec-mu)/sigma;
    xi_X = xi*X;
    tmp = min(xi_X);
    if tmp < -1
        f = big;
        return
    end

    % Compute log-likelihood
    for t = 1:T
        k = nobs_vec(t);
        ln_1 = -(log(factorial(k))+k*log(sigma));
        x  = (tau_vec(t)-mu)/sigma;
        x1 = -((1+xi*x).^(-1/xi));
        x2 = 0;
        for ik = 1:k
            tmp = xi*((Y_data(t,ik)-mu)/sigma);
            tmp = log1p(tmp);
            x2 = x2-(1+1/xi)*tmp;
        end
        llf_vec(t) = ln_1+x1+x2;
    end
    llf = sum(llf_vec);
    f = -llf;
    
end