function f = minus_llf_gev_con_mu(x,Y)
% Minus log-likelihood from GEV distribution .. data are in global Y, where Y is T x k
% Value of mu is constrained to equal sigma/xi
    small = 1.0E-10;
    big = 1.0E+8;
    T = size(Y,1);
    xi = x(1);
    sigma = x(2);
    mu = sigma/xi;
    if sigma <= 0
        f = big;
        return
    end
    ln_pdf = 0;
    for t = 1:T
     ln_pdf_t = llf_GEV_t(Y(t,:)',xi,sigma,mu);
     ln_pdf = ln_pdf + ln_pdf_t;
    end
    f = -ln_pdf;
    
  end