(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    117307,       2530]
NotebookOptionsPosition[    115935,       2486]
NotebookOutlinePosition[    116276,       2501]
CellTagsIndexPosition[    116233,       2498]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"phi", "[", 
   RowBox[{"l_", ",", "s_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}]}], 
   RowBox[{"Cos", "[", 
    RowBox[{"l", " ", "Pi", " ", "s"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", "14"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"my", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R2", "[", 
    RowBox[{"r_", ",", "ps_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Integrate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"phi", "[", 
           RowBox[{"l", ",", "s"}], "]"}], 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}], "^", "2"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"l", ",", "1", ",", "q"}], "}"}]}], "]"}], "/", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}], "-", 
         "my"}], ")"}], "^", "2"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"prec", "=", "5"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2grid", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", 
       RowBox[{
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{"R2", "[", 
           RowBox[{"r", ",", "ps"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"ps", ",", "0", ",", "Pi"}], "}"}], ",", 
          RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "/", "Pi"}], 
       ",", 
       RowBox[{"Max", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NMaximize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"0", "<=", "ps", "\[LessEqual]", "2"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"NMaximize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"2", "<=", "ps", "\[LessEqual]", "Pi"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NMinimize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"0", "<=", "ps", "\[LessEqual]", "2"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"NMinimize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"2", "<=", "ps", "\[LessEqual]", "Pi"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0.001", ",", "22", ",", ".05"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<c:\\R2dat_mean_eigen.dat\>\"", ",", "R2grid"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2grid", "=", 
   RowBox[{"Transpose", "[", "R2grid", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"R2grid", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mkx", "[", "l_", "]"}], ":=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"rs", ",", "l"}], "}"}], "]"}]}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "]"}], ",", 
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "]"}]}], "}"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.4038736219968786`*^9, 3.403873626231335*^9}, {
   3.4038738519387937`*^9, 3.4038738531888175`*^9}, {3.403873968847288*^9, 
   3.403873989597687*^9}, 3.4038741763200216`*^9, 3.4038748798335285`*^9}],

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], " ", 
  RowBox[{"Cos", "[", 
   RowBox[{"l", " ", "\[Pi]", " ", "s"}], "]"}]}]], "Output",
 CellChangeTimes->{{3.4038738320321617`*^9, 3.403873854391966*^9}, 
   3.4038739928633747`*^9, 3.403875612878853*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(ps\\) near \\!\\({ps}\\) = \
\\!\\({1.5647092291470752`}\\). NIntegrate obtained \
\\!\\(3.152533943099614`\\) and \\!\\(0.019498045348224125`\\) for the \
integral and error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.4038756254572196`*^9}],

Cell[BoxData["\<\"c:\\\\R2dat_mean_eigen.dat\"\>"], "Output",
 CellChangeTimes->{{3.4038738320321617`*^9, 3.403873854391966*^9}, 
   3.4038739928633747`*^9, 3.403875676880082*^9}],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw92HdYzf0fx/E00E6DBu19Gmcibr4vEtKPzJCZkXHbidzcGlZkFC1Fg4ZZ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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], PointBox[CompressedData["
1:eJxFmHdYju0fh5NIRdo77fk0nhlZ98fMyuqN4jUjCfllvbzITFZmRlKUluxC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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], PointBox[CompressedData["
1:eJw9mGk0VWsAhk+miITIkNkxT2dUbsN+aY5mlQZXISEUhQZCKakUTS7dKEUp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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->Automatic,
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{{3.4038738320321617`*^9, 3.403873854391966*^9}, 
   3.4038739928633747`*^9, 3.403875676895707*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"phi", "[", 
    RowBox[{"l_", ",", "s_"}], "]"}], "=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"l", ",", "2"}], "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}]}], 
      RowBox[{"Cos", "[", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}], " ", "Pi", " ", 
        RowBox[{"s", "/", "2"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}]}], 
      RowBox[{"Sin", "[", 
       RowBox[{"l", " ", "Pi", " ", "s"}], "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", "14"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"my", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R2", "[", 
    RowBox[{"r_", ",", "ps_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Integrate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"phi", "[", 
           RowBox[{"l", ",", "s"}], "]"}], 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}], "^", "2"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"l", ",", "1", ",", "q"}], "}"}]}], "]"}], "/", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}], "-", 
         "my"}], ")"}], "^", "2"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prec", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"R2grid", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", 
       RowBox[{
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{"R2", "[", 
           RowBox[{"r", ",", "ps"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"ps", ",", "0", ",", "Pi"}], "}"}], ",", 
          RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "/", "Pi"}], 
       ",", 
       RowBox[{"Max", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NMaximize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"0", "<=", "ps", "\[LessEqual]", "2"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"NMaximize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"2", "<=", "ps", "\[LessEqual]", "Pi"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NMinimize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"0", "<=", "ps", "\[LessEqual]", "2"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"NMinimize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"2", "<=", "ps", "\[LessEqual]", "Pi"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0.001", ",", "22", ",", ".05"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<c:\\R2dat_mean_Fourier.dat\>\"", ",", "R2grid"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2grid", "=", 
   RowBox[{"Transpose", "[", "R2grid", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"R2grid", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mkx", "[", "l_", "]"}], ":=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"rs", ",", "l"}], "}"}], "]"}]}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "]"}], ",", 
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.403873876329887*^9, 3.403873876595517*^9}, {
   3.4038739985978594`*^9, 3.403874010723092*^9}, 3.4038748862867775`*^9}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{"l", ",", "2"}], "]"}], "\[Equal]", "1"}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["2", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"l", "+", "1"}], ")"}], " ", "\[Pi]", " ", "s"}], "]"}]}], ",",
    
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"l", " ", "\[Pi]", " ", "s"}], "]"}]}]}], "]"}]], "Output",
 CellChangeTimes->{3.4038739180806885`*^9, 3.403875676911332*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(ps\\) near \\!\\({ps}\\) = \
\\!\\({1.5647092291470752`}\\). NIntegrate obtained \
\\!\\(2.898006937503075`\\) and \\!\\(0.018363815771765088`\\) for the \
integral and error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message",
 CellChangeTimes->{3.403873929284029*^9, 3.403875688099047*^9}],

Cell[BoxData["\<\"c:\\\\R2dat_mean_Fourier.dat\"\>"], "Output",
 CellChangeTimes->{3.4038739180806885`*^9, 3.403875742303213*^9}],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxFmHk8VPsbgIdUkmTflzHWwZhddVPnVXSTq41UFKVF0dUqpKhEN0XJUqiE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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], PointBox[CompressedData["
1:eJxFmHlcjekbh6MkJHWK9n3vtJwV2d5vIdsgsmRtiKSx/ColhlQUQoqIGktU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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], PointBox[CompressedData["
1:eJxFmGlYjfkfh48kSrRo39fTXmfVIJ6PJVnmIEuyE6JFK4p/VFppGEmWUEpJ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->Automatic,
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{3.4038739180806885`*^9, 3.403875742318838*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", "=", "14"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"phi", "[", "s_", "]"}], "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{"l", ",", "2"}], "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{"2", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], 
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "+", "1"}], ")"}], " ", "Pi", " ", "s"}], "]"}]}], ",",
       
      RowBox[{
       RowBox[{"2", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], 
       RowBox[{"Sin", "[", 
        RowBox[{"l", " ", "Pi", " ", "s"}], "]"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "1", ",", "q"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"xx", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"s", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"phidt", "[", "s_", "]"}], "=", 
  RowBox[{
   RowBox[{"phi", "[", "s", "]"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"u", "-", 
           RowBox[{"1", "/", "2"}]}], ")"}], 
         RowBox[{"phi", "[", "u", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}], "/", "xx"}], 
     ")"}], 
    RowBox[{"(", 
     RowBox[{"s", "-", 
      RowBox[{"1", "/", "2"}]}], ")"}]}]}]}], "\n", 
 RowBox[{
  RowBox[{"XX", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{"Times", ",", 
       RowBox[{"phidt", "[", "s", "]"}], ",", 
       RowBox[{"phidt", "[", "s", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Xy", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"phidt", "[", "s", "]"}], 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"my", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"R2", "[", 
     RowBox[{"r_", ",", "ps_"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Xy", ".", 
       RowBox[{"Inverse", "[", "XX", "]"}], ".", "Xy"}], ")"}], "/", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}], "-", 
          "my"}], ")"}], "^", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prec", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"R2grid", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", 
       RowBox[{
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{"R2", "[", 
           RowBox[{"r", ",", "ps"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"ps", ",", "0", ",", "Pi"}], "}"}], ",", 
          RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "/", "Pi"}], 
       ",", 
       RowBox[{"Max", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NMaximize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"0", "<=", "ps", "\[LessEqual]", "2"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"NMaximize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"2", "<=", "ps", "\[LessEqual]", "Pi"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NMinimize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"0", "<=", "ps", "\[LessEqual]", "2"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"NMinimize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"2", "<=", "ps", "\[LessEqual]", "Pi"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0.001", ",", "22", ",", ".05"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<c:\\R2dat_trend_Fourier.dat\>\"", ",", "R2grid"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2grid", "=", 
   RowBox[{"Transpose", "[", "R2grid", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"R2grid", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mkx", "[", "l_", "]"}], ":=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"rs", ",", "l"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "]"}], ",", 
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "]"}]}], "}"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{3.4038740068480177`*^9, 3.403875561190361*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"4", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"6", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"6", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"8", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"8", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"10", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"10", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"12", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"12", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"14", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"14", " ", "\[Pi]", " ", "s"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.403875742396965*^9}],

Cell[BoxData[
 FractionBox["1", "12"]], "Output",
 CellChangeTimes->{3.403875743084478*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"6", " ", 
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], "\[Pi]"], "+", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "\[Pi]", " ", "s"}], "]"}]}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"3", " ", 
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], "\[Pi]"], "+", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"4", " ", "\[Pi]", " ", "s"}], "]"}]}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"6", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], "\[Pi]"], "+", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"6", " ", "\[Pi]", " ", "s"}], "]"}]}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"8", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], 
     RowBox[{
      SqrtBox["2"], " ", "\[Pi]"}]], "+", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"8", " ", "\[Pi]", " ", "s"}], "]"}]}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"10", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"6", " ", 
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], 
     RowBox[{"5", " ", "\[Pi]"}]], "+", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"10", " ", "\[Pi]", " ", "s"}], "]"}]}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"12", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], "\[Pi]"], "+", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"12", " ", "\[Pi]", " ", "s"}], "]"}]}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"14", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"6", " ", 
      SqrtBox["2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], 
     RowBox[{"7", " ", "\[Pi]"}]], "+", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"14", " ", "\[Pi]", " ", "s"}], "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.4038757439126186`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message",
 CellChangeTimes->{3.4038757878978386`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(ps\\) near \\!\\({ps}\\) = \
\\!\\({1.5647092291470752`}\\). NIntegrate obtained \
\\!\\(0.005672295370273346`\\) and \\!\\(0.005488365486736656`\\) for the \
integral and error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message",
 CellChangeTimes->{3.4038757879603395`*^9}],

Cell[BoxData["\<\"c:\\\\R2dat_trend_Fourier.dat\"\>"], "Output",
 CellChangeTimes->{3.4038758471489763`*^9}],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw92Hk0VesDxnFzRJkiqczzeEZut679cBPdKEWSdKmkWZNmdVMapNxEQmYh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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], PointBox[CompressedData["
1:eJxFmHc8lusfx4WWJJ6kkLI3z1Yo9wedtpb2UCmaR0elNAjFiXZpUacUlTSM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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], PointBox[CompressedData["
1:eJw9mHk4lekbgGULlT2y747dWStj+R5KU6GyJGXKhBQpydaqUKRQSoo2exEp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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->Automatic,
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{3.4038758471646013`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", "=", "13"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ax", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"s", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}], 
      RowBox[{"(", 
       RowBox[{"s", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"as", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"ax", "\[Equal]", "0"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", 
          RowBox[{"9", "+", 
           RowBox[{"j", " ", "2", " ", "Pi"}]}]}], "}"}]}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "99"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"phi", "[", "s_", "]"}], "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{"l", ",", "2"}], "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{"2", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], 
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "+", "1"}], ")"}], " ", "Pi", " ", "s"}], "]"}]}], ",",
       
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{
           RowBox[{"as", "[", 
            RowBox[{"[", 
             RowBox[{"l", "/", "2"}], "]"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"as", "[", 
              RowBox[{"[", 
               RowBox[{"l", "/", "2"}], "]"}], "]"}], "-", 
             RowBox[{"Sin", "[", 
              RowBox[{"as", "[", 
               RowBox[{"[", 
                RowBox[{"l", "/", "2"}], "]"}], "]"}], "]"}]}], ")"}]}]}], 
         ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"l", "+", "2"}], ")"}], "/", "2"}], ")"}]}], 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"as", "[", 
          RowBox[{"[", 
           RowBox[{"l", "/", "2"}], "]"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"s", "-", 
           RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "1", ",", "q"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"my", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"R2", "[", 
     RowBox[{"r_", ",", "ps_"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"Integrate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"phi", "[", "s", "]"}], 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}], "^", "2"}], 
      "]"}], "/", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"Pi", " ", "r", " ", "s"}], "+", "ps"}], "]"}], "-", 
          "my"}], ")"}], "^", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prec", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"R2grid", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", 
       RowBox[{
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{"R2", "[", 
           RowBox[{"r", ",", "ps"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"ps", ",", "0", ",", "Pi"}], "}"}], ",", 
          RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "/", "Pi"}], 
       ",", 
       RowBox[{"Max", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NMaximize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"0", "<=", "ps", "\[LessEqual]", "2"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"NMaximize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"2", "<=", "ps", "\[LessEqual]", "Pi"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NMinimize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"0", "<=", "ps", "\[LessEqual]", "2"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"NMinimize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R2", "[", 
               RowBox[{"r", ",", "ps"}], "]"}], ",", 
              RowBox[{"2", "<=", "ps", "\[LessEqual]", "Pi"}]}], "}"}], ",", 
            "ps", ",", 
            RowBox[{"PrecisionGoal", "\[Rule]", "prec"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0.001", ",", "22", ",", ".05"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<c:\\R2dat_trend_eigen.dat\>\"", ",", "R2grid"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2grid", "=", 
   RowBox[{"Transpose", "[", "R2grid", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"R2grid", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mkx", "[", "l_", "]"}], ":=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"rs", ",", "l"}], "}"}], "]"}]}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "]"}], ",", 
    RowBox[{"mkx", "[", 
     RowBox[{"R2grid", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "]"}]}], "}"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.403874023582714*^9, 3.4038755958160257`*^9, {3.403876016855359*^9, 
   3.4038760190585265`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{"1.4488117081439928`", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"8.986818915818128`", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.426012740531058`"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"15.450503673875414`", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"6", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{"1.420148188173782`", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"21.808243318857798`", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"8", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.4177828709307543`"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"28.132387825662946`", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"10", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{"1.4165959638925132`", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"34.44151054386154`", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"12", " ", "\[Pi]", " ", "s"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.4159164500143344`"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"40.74260591857512`", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", "s"}], ")"}]}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"14", " ", "\[Pi]", " ", "s"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.403875847555234*^9, 3.403876057996774*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message",
 CellChangeTimes->{3.403875883962183*^9, 3.4038760864035697`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(ps\\) near \\!\\({ps}\\) = \
\\!\\({1.5647092291470752`}\\). NIntegrate obtained \
\\!\\(0.0056722953702734395`\\) and \\!\\(0.005488365486736657`\\) for the \
integral and error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message",
 CellChangeTimes->{3.403875883962183*^9, 3.4038760864191947`*^9}],

Cell[BoxData["\<\"c:\\\\R2dat_trend_eigen.dat\"\>"], "Output",
 CellChangeTimes->{3.403875847555234*^9, 3.403876175389653*^9}],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw92HlUzdsbx/FK86BBc+E0z3VGXcJ+KmVooNBF1xRKuDKkjAmhuJEmiZSk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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], PointBox[CompressedData["
1:eJxFmHc41e0fx62GJjKy17HOMc5Mqqfvu1JPew8qetLS/qlIS+FpP2ippJTR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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], PointBox[CompressedData["
1:eJw9mHk8lOsbh8lalqQ0yDr2ZcxmUOK9U1RKljqWNodKqagQKlKWrBWSNdFC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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->Automatic,
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{3.403875847555234*^9, 3.403876175405278*^9}]
}, Open  ]]
},
WindowSize->{1014, 695},
WindowMargins->{{28, Automatic}, {Automatic, 6}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 5282, 155, 530, "Input"],
Cell[5875, 180, 248, 6, 46, "Output"],
Cell[6126, 188, 657, 12, 115, "Message"],
Cell[6786, 202, 179, 2, 42, "Output"],
Cell[6968, 206, 19027, 319, 360, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26032, 530, 5613, 167, 530, "Input"],
Cell[31648, 699, 558, 18, 60, "Output"],
Cell[32209, 719, 670, 12, 108, "Message"],
Cell[32882, 733, 129, 1, 42, "Output"],
Cell[33014, 736, 19389, 324, 360, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52440, 1065, 6845, 210, 719, "Input"],
Cell[59288, 1277, 1781, 59, 109, "Output"],
Cell[61072, 1338, 91, 2, 60, "Output"],
Cell[61166, 1342, 3339, 118, 333, "Output"],
Cell[64508, 1462, 552, 10, 108, "Message"],
Cell[65063, 1474, 653, 12, 108, "Message"],
Cell[65719, 1488, 108, 1, 42, "Output"],
Cell[65830, 1491, 19384, 325, 360, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85251, 1821, 7449, 229, 692, "Input"],
Cell[92703, 2052, 2425, 76, 240, "Output"],
Cell[95131, 2130, 574, 10, 108, "Message"],
Cell[95708, 2142, 676, 12, 108, "Message"],
Cell[96387, 2156, 126, 1, 42, "Output"],
Cell[96516, 2159, 19403, 324, 360, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
