#include <oxstd.h>
#include <arma.h>
#include <database.h>
#include <oxdraw.h>
#include <oxfloat.h>

const decl pi=3.1415926535897932385;
const decl loops=100000;
const decl q=13;
const decl T=208;

decl R,vert;

decl phi,v;

decl LFURSig1i,LFURSig0i;
decl S0mats,S1mats,H0mats,H1mats;
const decl n=100;

matsqrt(const A)
{
	decl evec,eval;
	eigensym(A,&eval,&evec);
	eval=fabs(eval);
	return (evec.*sqrt(eval))*evec';
}

mymatinv(const A)
{
	return invertsym(A)*(determinant(A)^(1/rows(A)));
}

LFST()
{ 	decl b=sqr(v);
	return sumc(b) / sumc(b ./ (1+ 10^2 ./sqr(pi*(range(1,q)'))));
}

LFUR()
{ 	return (v'LFURSig0i*v)/(v'LFURSig1i*v);   }

H0()
{
	decl nx,stat=0;
	for(nx=0; nx<n; nx++)
		stat+=(v'H0mats[nx]*v)^(-q/2);
	return stat/sumc(sumsqrc(v))^(-q/2);
}

H1()
{
	decl nx,stat=0;
	for(nx=0; nx<n; nx++)
		stat+=(v'H1mats[nx]*v)^(-q/2);
	return stat/(v'LFURSig0i*v)^(-q/2);
}

S0()
{
	decl nx,stat=0;
	for(nx=0; nx<n; nx++)
		stat+=(v'S0mats[nx]*v)^(-q/2);
	return stat/sumc(sumsqrc(v))^(-q/2);
}

S1()
{
	decl nx,stat=0;
	for(nx=0; nx<n; nx++)
		stat+=(v'S1mats[nx]*v)^(-q/2);
	return stat/(v'LFURSig0i*v)^(-q/2);
}

mkLFURSigi(const c)
{
 	decl VX=zeros(q,q);
	decl ec=exp(c); decl e2c=ec*ec;

	decl j,l;
	for(j=1;j<=q;j++)
	for(l=1;l<j;l++)
		VX[j-1][l-1]=(c>0)?
				((-1)^l*c*((-ec)*((-1)^j + (-1)^l) + 
			    cos((j + l)*M_PI) + 1))/
			  (ec*((c^2 + j^2*M_PI^2)*(c^2 + l^2*M_PI^2)))
				:
				-((c*(-2*ec*((-1)^j + (-1)^l) + 
			    (2 + (-1)^(j + l))*e2c + 
			     (-1)^(j + l)))/(e2c*((c^2 + j^2*M_PI^2)*
		     (c^2 + l^2*M_PI^2))))
					;
	VX+=VX';
	for(j=1;j<=q;j++)
		VX[j-1][j-1]=(c>0)?
			   (2*(-1)^j*c + ec*(M_PI^2*j^2 + (c - 2)*c))/
			  (ec*(c^2 + j^2*M_PI^2)^2)
				:
				(c^2 + ((-1 + 4*(-1)^j*ec)/e2c - 3)*c + 
 				  j^2*M_PI^2)/(c^2 + j^2*M_PI^2)^2
				;
	LFURSig1i=invertsym(VX);
		
}

mkHSmats()
{
	decl S0=unit(q), S1=diag(range(1,q).^(-2)); 
	S0mats=new array[n];
	S1mats=S0mats; H0mats=S0mats; H1mats=S0mats;
	
	decl Tx=1000;
	decl phix=zeros(Tx,q);
	decl tau=range(1,Tx)'-.5;
	decl k;
	for(k=1;k<=q;k++)
		phix[][k-1]=(2^.5)*cos(pi*k*tau/Tx)/sqrt(Tx);
	
	decl SigI1=cumulate(cumulate(unit(Tx)'))/sqr(T);

	decl nx;
	for(nx=0; nx<n; nx++){
		decl Lam=diag(exp(cumulate(rann(q,1))*5/q));
		S0mats[nx]=Lam*S0*Lam;
		S1mats[nx]=Lam*S1*Lam;

		decl pv=exp(cumulate(rann(Tx,1))*6/sqrt(q*Tx)).*phix;
		H0mats[nx]=pv'pv;
		pv=cumulate(pv)/sqrt(Tx);
		H1mats[nx]=pv'pv;

		H0mats[nx]=mymatinv(H0mats[nx]);
		H1mats[nx]=mymatinv(H1mats[nx]);
		S0mats[nx]=mymatinv(S0mats[nx]);
		S1mats[nx]=mymatinv(S1mats[nx]);
	}		
}



getgamma(const l, const R, const c)
{
	return (l>0)? (1-c)*sin(2*l*pi/R)/(l*pi)
			: (2+c*(R-2))/R;
}

mkphi()
{
	phi=zeros(T,q);
	decl tau=range(1,T)'-.5;
	decl k;
	for(k=1;k<=q;k++)
		phi[][k-1]=(2*T/(k*pi))*sin(k*pi/(2*T))*(2^.5)*cos(pi*k*tau/T)/sqrt(T);

}

main()
{			
	format(5000);

	mkLFURSigi(14);
	LFURSig0i=diag(sqr(range(1,q)*pi));
	mkHSmats();
	
	mkphi();
	decl vert=zeros(loops,6);
	
	decl lc;
	for(lc=0;lc<loops;lc++){
		decl X=rann(q,1);
		v=X/sqrt(sumsqrc(X));
		vert[lc][0]=LFST();
		vert[lc][1]=H0();
		vert[lc][2]=S0();
		X./=range(1,q)';
		v=X/sqrt(sumsqrc(X));
		vert[lc][3]=LFUR();
		vert[lc][4]=H1();
		vert[lc][5]=S1();
	}

	decl cv=sortc(vert)[.95*loops][];
	print("cv",cv);

	decl cvec=range(0,3,.2)';
	decl sizes=zeros(rows(cvec),columns(vert));
	decl Y=rann(T,loops);
	
	decl cc;
	for(cc=0;cc<rows(cvec);cc++){
	println(cc+1,"  out of  ",rows(cvec));	
	decl Sig=zeros(T,T);
	decl i,j;
	for(i=0;i<T;i++)
	for(j=0;j<T;j++)
		Sig[i][j]=getgamma(fabs(i-j),32,cvec[cc]);
	decl cphi=phi'matsqrt(Sig);
	decl F=cumulate(unit(T));
	decl cphiF=phi'F*matsqrt(Sig);
	for(lc=0;lc<loops;lc++){
		decl X=cphi*Y[][lc];
		v=X/sqrt(sumsqrc(X));
		vert[lc][0]=LFST();
		vert[lc][1]=H0();
		vert[lc][2]=S0();
 		X=cphiF*Y[][lc];
		v=X/sqrt(sumsqrc(X));
		vert[lc][3]=LFUR();
		vert[lc][4]=H1();
		vert[lc][5]=S1();
	}
	sizes[cc][]=meanc(vert.>cv.? 1 .: 0);
	}
	print(cvec~sizes);
}					 