#include <oxstd.h>
#include <arma.h>
#include <database.h>
#include <oxdraw.h>

decl q=13;
const decl an=1000;
const decl anzmodels=3;
const decl loops=50000;

const decl FR=0; const decl OU=1; const decl LL=2;
decl phi;
decl mats,mpara;
decl pargrid, ngrid=80;
decl as;

const decl pi=3.14159265;

mkphimean()
{
	phi=zeros(an,q);
	decl i,j;
	for(i=1;i<an+1;i++)
		for(j=0;j<q;j++)
			phi[i-1][j]=sqrt(2)*cos(pi*(j+1)*i/an);
	decl X=ones(an,1),b;
	olsc(phi,X,&b);
	phi=phi-X*b;
	
}

mkphitrend()
{
	phi=zeros(an,q);
	decl a;
	decl i,j;
	for(j=0;j<q;j++)
		if(imod(j,2)==0){
		for(i=1;i<an+1;i++)
			phi[i-1][j]=sqrt(2)*cos(pi*(j+2)*i/an);}
		else{
		a=as[j/2];
		for(i=1;i<an+1;i++)
			phi[i-1][j]=sqrt(2*a)*sin(a*(i/an-.5))/sqrt(a-sin(a));
	}
	decl X=ones(an,1)~(range(1,an)'/an),b;
	olsc(phi,X,&b);
	phi=phi-X*b;

}

mkSigs(const sig, const model, const theta)
{
	decl gamma=zeros(an,1);

	if(model==FR){
		decl d=theta-((theta>.5)?1:0);
		gamma[0]=gammafact(1-2*d)/sqr(gammafact(1-d));
		decl x;
		for(x=1;x<an;x++)
			gamma[x]=sin(pi*d)*exp(loggamma(1-2*d)+loggamma(x+d)-loggamma(x+1-d))/pi;
		decl i;
		for(i=0;i<an;i++)
			sig[0][i][i:]=gamma[0:an-i-1]';
		sig[0]=setlower(sig[0],sig[0]');
		if (theta>.5) sig[0]=cumulate(cumulate(sig[0])' )';
	}

	if(model==OU){
		decl x; decl rho=1-theta/an;
		if(rho<0) rho=0.0000001;
		gamma[0]=1/(1-rho^2);
		for(x=1;x<an;x++)
			gamma[x]=gamma[x-1]*rho;
		decl i;
		for(i=0;i<an;i++)
			sig[0][i][i:]=gamma[0:an-i-1]';
		sig[0]=setlower(sig[0],sig[0]');
	}

	if(model==LL){
		sig[0]=unit(an)+cumulate(cumulate(sqr(theta/an)*unit(an))' );
	}
}

main()
{
	format(5000);

	pargrid=zeros(anzmodels,ngrid);
	pargrid[FR][]=range(0,1,1/(ngrid-1));
	pargrid[OU][]=10 .^(-1+3.8*range(0,ngrid-1)/(ngrid-1));
	pargrid[LL][]=10 .^(-1+3.5*range(0,ngrid-1)/(ngrid-1));
	print(pargrid);
	decl i;

	decl mc;
	mats=new array[anzmodels];
	decl matsall;

	as=loadmat("magic_as.mat");

	decl detrendc;
	for(detrendc=0;detrendc<2;detrendc++,q--){
	
	decl filename;
	if(detrendc==0)	filename="tvdmatsmean.mat"; else filename="tvdmatstrend.mat";


//	*************  make mats *****************
	if(detrendc==0)	mkphimean(); else mkphitrend();

	matsall=zeros(ngrid*anzmodels*q,q);
	for(mc=0;mc<anzmodels;mc++){
		decl nSig=zeros(an,an);
		decl qSig=zeros(q,q);
		mats[mc]=new array[ngrid];
		for(i=0;i<ngrid;i++){
			print(mc,i);
			mkSigs(&nSig,mc,pargrid[mc][i]);
			qSig=invertsym(phi'nSig*phi);
			decl detsign;
			mats[mc][i]=qSig/exp(logdet(qSig,&detsign)/q);
			if(detsign!=1) print("determinant warning");
			matsall[mc*q*ngrid+i*q:][]=mats[mc][i];
			}
	}

	savemat(filename,matsall);

//	*************  load mats *****************
	matsall=loadmat(filename);
	for(mc=0;mc<anzmodels;mc++){
		mats[mc]=new array[ngrid];
		for(i=0;i<ngrid;i++){
			mats[mc][i]=matsall[mc*q*ngrid+i*q:mc*q*ngrid+i*q+q-1][];
			}
	}
	

	mc=0;
	for(mc=0;mc<anzmodels;mc++){

	decl dist=zeros(anzmodels,ngrid);
	
	decl ith=0;

	for(ith=0;ith<ngrid;ith++){
	decl Q=choleski(invertsym(mats[mc][ith]));
	decl vert=zeros(loops,anzmodels*ngrid);
	decl loopc;
	for(loopc=0;loopc<loops;loopc++){
	decl y=Q*rann(q,1);
	vert[loopc][ngrid*mc]=y'mats[mc][ith]*y;
	decl mcx;
	for(mcx=0;mcx<anzmodels;mcx++)
		if(mcx!=mc)
		for(i=0;i<ngrid;i++)
			vert[loopc][ngrid*mcx+i]=y'mats[mcx][i]*y;
	}
	vert=(vert./vert[][ngrid*mc]).^(-q/2);

	decl mcx;
	for(mcx=0;mcx<anzmodels;mcx++)
		if(mcx!=mc){
		decl tvd=zeros(1,ngrid);
		decl lr=zeros(loops,1);
		for(i=0;i<ngrid;i++){
			lr=vert[][ngrid*mcx+i];
			tvd[0][i]=meanc(lr.< 1 .?(1-lr).:0);
		}
		dist[mcx][ith]=min(tvd);
		}
	}
	print("q=",q);
	print(pargrid[mc][]|(dropr(dist,mc)));
	}
	}
}					 