proc(1) = dif2_cov(t,c);

/* Compute Covariance Matrix of integrated diffusion with local to unity parameter c */

local rho, rvec,x,i,cov,scale,sum_mat;

@ Construct summation matrix @
sum_mat=zeros(t,t);
for i (1,t,1);
  sum_mat[i,1:i]=ones(1,i);
endfor;


 rho=1-c/t;
 if rho .>= 1;
  rvec=seqm(1,rho,t);
  x=zeros(t,t);
  x[.,1]=rvec;
  for i (2,t,1);
   x[i:t,i]=rvec[1:t+1-i];
  endfor;
  cov=x*x';
 else;
  cov=eye(t);            
  for i (1,t-1,1);
   for j (i+1,t,1);
    cov[i,j]=rho^(j-i);
    cov[j,i]=cov[i,j];
   endfor;
  endfor;
  scale=1/(1-rho*rho);
  cov=scale*cov;
 endif;
 
 @ -- Summed Covariance Matrix -- @
 cov=sum_mat*cov*sum_mat';

 retp(cov);
endp;

