proc(1) = dif_cov(t,c);

/* Compute Covariance Matrix of diffusion with local to unity parameter c */

local rho, rvec,x,i,cov,scale;

 rho=1-c/t;
 if rho .>= 1;
  rvec=seqm(1,rho,t);
  x=zeros(t,t);
  x[.,1]=rvec;
  for i (2,t,1);
   x[i:t,i]=rvec[1:t+1-i];
  endfor;
  cov=x*x';
 else;
  cov=eye(t);            
  for i (1,t-1,1);
   for j (i+1,t,1);
    cov[i,j]=rho^(j-i);
    cov[j,i]=cov[i,j];
   endfor;
  endfor;
  scale=1/(1-rho*rho);
  cov=scale*cov;
 endif;
  
 retp(cov);
endp;

