proc(1) = frac_cov(t,d);

/* Compute Covariance Matrix of fractional model with parameter d 
   Note d must be between -0.5 and 1.5
   If d > 0.5 then this computes variance of integrated stationary model 
*/


local dsave,acv,gamd,gam_md,fac,t1,ghd,ghmd,pow,cov_vech,cov,scale,sum_mat,var;

dsave = d;
if dsave .> 0.50;
 d=d-1;
endif;

if d .< -0.5;
 "This value of d is not allowed: d = ";;dsave;
 cov=miss(0,0);
elseif d .> 0.5;
 "This value of d is not allowed: d = ";;dsave;
 cov=miss(0,0);
elseif abs(d) .< 0.000001;
 cov=eye(t);
else;
 if (0.5-d) .< .0001;
  d=0.4999;
 endif;
 if (d+0.5) .< .0001;
  d=-0.4999;
 endif;
 @ Compute autocorrelations @
 acv=zeros(t,1);
 acv[1]=1;
 if d .> 0;
  gamd=gamma(d);
 else;
  gamd=gamma(1+d)/d;
 endif;
 gam_md=gamma(1-d);
 fac=gam_md/gamd;
 t1=minc(100|t-1);
 for h (1,t1,1);
  ghd=gamma(h+d);
  ghmd=gamma(h-d+1);
  acv[h+1]=(ghd/ghmd)*fac;
 endfor;
 pow=2*d-1;
 for h (t1+1,t-1,1);
  acv[h+1]=fac*(h.^pow);
 endfor;
 for i (1,t,1);
  if i .== 1;
   cov_vech=acv[1];
  else;
   cov_vech=cov_vech|rev(acv[1:i]);
  endif;
 endfor;
 cov=xpnd(cov_vech);
 @ Compute Variance to get correct scale -- this is useful in h_cov_ha_frac where the scale is important @
 var=gamma(1-2*d)/(gamma(1-d))^2;
 cov=cov*var;
endif;

if dsave .> 0.50;
 @ Construct summation matrix @
 sum_mat=zeros(t,t);
 for i (1,t,1);
   sum_mat[i,1:i]=ones(1,i);
 endfor;
 cov=sum_mat*cov*sum_mat';
endif;
 
retp(cov);
endp;

